/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.cuisinedelight.content.item;

import dev.xkmc.cuisinedelight.content.block.CuisineSkilletBlockEntity;
import dev.xkmc.cuisinedelight.content.item.CuisineSkilletItem;
import dev.xkmc.cuisinedelight.content.logic.CookedFoodData;
import dev.xkmc.cuisinedelight.content.logic.CookingData;
import dev.xkmc.cuisinedelight.content.recipe.BaseCuisineRecipe;
import dev.xkmc.cuisinedelight.init.registrate.CDItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class PlateItem
extends Item {
    public PlateItem(Item.Properties pProperties) {
        super(pProperties);
    }

    private void giveBack(ItemStack foodStack, CookedFoodData food, ReturnTarget target) {
        target.addItem(foodStack);
        target.addExp(food.score() * food.size() / 100);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack plateStack = player.getItemInHand(hand);
        InteractionHand otherHand = hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        ItemStack skilletStack = player.getItemInHand(otherHand);
        if (!skilletStack.is((Item)CDItems.SKILLET.get())) {
            return InteractionResultHolder.pass((Object)plateStack);
        }
        CookingData data = CuisineSkilletItem.getData(skilletStack);
        if (data == null) {
            return InteractionResultHolder.pass((Object)plateStack);
        }
        if (!level.isClientSide()) {
            CuisineSkilletItem.setData(skilletStack, null);
            data.stir(level.getGameTime(), 0);
            CookedFoodData food = CookedFoodData.of(data);
            ItemStack foodStack = BaseCuisineRecipe.findBestMatch(level, food);
            plateStack.shrink(1);
            this.giveBack(foodStack, food, new PlayerTarget(player));
        }
        return InteractionResultHolder.success((Object)plateStack);
    }

    public InteractionResult useOn(UseOnContext ctx) {
        Level level = ctx.getLevel();
        Player player = ctx.getPlayer();
        BlockEntity blockEntity = level.getBlockEntity(ctx.getClickedPos());
        if (blockEntity instanceof CuisineSkilletBlockEntity) {
            CuisineSkilletBlockEntity be = (CuisineSkilletBlockEntity)blockEntity;
            if (be.cookingData.contents.isEmpty()) {
                return InteractionResult.PASS;
            }
            if (!level.isClientSide()) {
                CookingData data = be.cookingData;
                data.stir(level.getGameTime(), 0);
                CookedFoodData food = CookedFoodData.of(data);
                ItemStack foodStack = BaseCuisineRecipe.findBestMatch(level, food);
                ctx.getItemInHand().shrink(1);
                if (player != null) {
                    this.giveBack(foodStack, food, new PlayerTarget(player));
                } else {
                    this.giveBack(foodStack, food, new BlockTarget(ctx));
                }
                be.cookingData = new CookingData();
                be.sync();
                be.setChanged();
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static interface ReturnTarget {
        public void addItem(ItemStack var1);

        public void addExp(int var1);
    }

    public record PlayerTarget(Player player) implements ReturnTarget
    {
        @Override
        public void addItem(ItemStack foodStack) {
            this.player.getInventory().placeItemBackInInventory(foodStack);
        }

        @Override
        public void addExp(int i) {
            ExperienceOrb.award((ServerLevel)((ServerLevel)this.player.level()), (Vec3)this.player.position(), (int)i);
        }
    }

    public record BlockTarget(UseOnContext ctx) implements ReturnTarget
    {
        @Override
        public void addItem(ItemStack foodStack) {
            Block.popResource((Level)this.ctx.getLevel(), (BlockPos)this.ctx.getClickedPos(), (ItemStack)foodStack);
        }

        @Override
        public void addExp(int i) {
            ExperienceOrb.award((ServerLevel)((ServerLevel)this.ctx.getLevel()), (Vec3)Vec3.atCenterOf((Vec3i)this.ctx.getClickedPos()), (int)i);
        }
    }
}

