/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.cuisinedelight.content.logic;

import dev.xkmc.cuisinedelight.content.logic.CookTransformConfig;
import dev.xkmc.cuisinedelight.content.logic.CookingData;
import dev.xkmc.cuisinedelight.content.logic.FoodType;
import dev.xkmc.cuisinedelight.content.logic.IngredientConfig;
import dev.xkmc.cuisinedelight.content.logic.transform.CookTransform;
import dev.xkmc.cuisinedelight.content.logic.transform.ItemStageTransform;
import dev.xkmc.cuisinedelight.content.logic.transform.Stage;
import dev.xkmc.cuisinedelight.init.data.CDConfig;
import dev.xkmc.l2serial.serialization.marker.SerialClass;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import vectorwing.farmersdelight.common.registry.ModEffects;

@SerialClass
public record CookedFoodData(int total, int size, int nutrition, int score, LinkedHashSet<FoodType> types, ArrayList<Entry> entries) {
    public static final FoodProperties BAD = new FoodProperties.Builder().nutrition(0).saturationModifier(0.0f).build();

    public static CookedFoodData of(CookingData data) {
        LinkedHashSet<FoodType> types = new LinkedHashSet<FoodType>();
        ArrayList<Entry> entries = new ArrayList<Entry>();
        int size = 0;
        int nutrition = 0;
        float penalty = 0.0f;
        for (CookingData.CookingEntry e : data.contents) {
            IngredientConfig.IngredientEntry config = IngredientConfig.get().getEntry(e.getItem());
            if (config == null) continue;
            boolean raw = (float)config.min_time > e.getDuration(data, 0.0f);
            boolean overcooked = (float)config.max_time < e.getDuration(data, 0.0f);
            boolean burnt = e.getMaxStirTime(data) > (float)config.stir_time;
            float badness = 0.0f;
            if (raw) {
                badness += config.raw_penalty;
            }
            if (overcooked || burnt) {
                badness += config.overcook_penalty;
            }
            int itemSize = config.size * e.getItem().getCount();
            penalty += (float)itemSize * badness;
            size += itemSize;
            nutrition += config.nutrition * itemSize;
            entries.add(new Entry(e.getItem(), itemSize, burnt, raw, overcooked));
            if (config.type == FoodType.NONE) continue;
            types.add(config.type);
        }
        float goodness = size == 0 ? 0.0f : Mth.clamp((float)(1.0f - penalty / (float)size), (float)0.0f, (float)1.0f);
        return new CookedFoodData(size, size, size == 0 ? 0 : Math.round(goodness * (float)nutrition / (float)size), Math.round(goodness * 100.0f), types, entries);
    }

    public FoodProperties toFoodData() {
        if (this.score < 60 || this.total == 0) {
            return BAD;
        }
        double mult = 1.0 + (double)(this.types.size() - 1) * (Double)CDConfig.SERVER.varietyBonus.get();
        if (this.score == 100) {
            mult += ((Double)CDConfig.SERVER.perfectionBonus.get()).doubleValue();
        }
        FoodProperties.Builder ans = new FoodProperties.Builder().nutrition((int)(mult * (double)((Integer)CDConfig.SERVER.baseServe.get()).intValue())).saturationModifier((float)((double)this.nutrition * (Double)CDConfig.SERVER.baseNutrition.get()));
        if (this.score == 100) {
            ans.fast().alwaysEdible();
        }
        LinkedHashMap<MobEffect, EffectData> map = new LinkedHashMap<MobEffect, EffectData>();
        for (Entry e : this.entries) {
            e.addMobEffects(map, this.total);
        }
        if (this.score == 100 && this.types.size() > 1) {
            ans.effect(() -> new MobEffectInstance(ModEffects.NOURISHMENT, (Integer)CDConfig.SERVER.nourishmentDuration.get() * this.types.size()), 1.0f);
        }
        map.forEach((k, v) -> ans.effect(() -> new MobEffectInstance(v.holder, Math.round(v.duration), v.level()), 1.0f));
        return ans.build();
    }

    public CookedFoodData saturationBonus(double v) {
        return new CookedFoodData(this.total, this.size, (int)((double)this.nutrition * v), this.score, this.types, this.entries);
    }

    public CookedFoodData shrink() {
        return new CookedFoodData(this.total, this.size - 1, this.nutrition, this.score, this.types, this.entries);
    }

    public record Entry(ItemStack stack, int itemSize, boolean burnt, boolean raw, boolean overcooked) {
        private void addMobEffects(Map<MobEffect, EffectData> map, int divisor) {
            IngredientConfig.IngredientEntry config = IngredientConfig.get().getEntry(this.stack);
            if (config == null) {
                return;
            }
            if (this.burnt || this.raw || this.overcooked) {
                return;
            }
            for (IngredientConfig.EffectEntry e : config.effects) {
                map.compute((MobEffect)e.effect().value(), (k, v) -> {
                    float ans = 1.0f * (float)e.time() * (float)this.stack.getCount() / (float)divisor;
                    if (v != null) {
                        if (v.level > e.level()) {
                            return v;
                        }
                        if (v.level == e.level()) {
                            return new EffectData(e.effect(), v.level, v.duration + ans);
                        }
                    }
                    return new EffectData(e.effect(), e.level(), ans);
                });
            }
        }

        public ItemStack getEatenStack() {
            ItemStageTransform t;
            CookTransform handler = CookTransformConfig.get(this.stack);
            if (handler instanceof ItemStageTransform && (t = (ItemStageTransform)handler).stage() != Stage.RAW) {
                ItemStack ans = t.next().getDefaultInstance();
                ans.setCount(this.stack.getCount());
                ans.applyComponents(this.stack.getComponentsPatch());
                return ans;
            }
            return this.stack;
        }
    }

    private record EffectData(Holder<MobEffect> holder, int level, float duration) {
    }
}

