/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.entities;

import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public abstract class CorpseBoundingBoxBase
extends Entity {
    public CorpseBoundingBoxBase(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public void recalculateBoundingBox() {
        Direction facing = this.entityData == null ? Direction.NORTH : Direction.fromYRot((double)this.getYRot());
        this.setBoundingBox(new AABB(this.getX() - (facing.getStepX() != 0 ? 1.0 : 0.5), this.getY(), this.getZ() - (facing.getStepZ() != 0 ? 1.0 : 0.5), this.getX() + (facing.getStepX() != 0 ? 1.0 : 0.5), this.getY() + 0.5, this.getZ() + (facing.getStepZ() != 0 ? 1.0 : 0.5)));
    }

    public void tick() {
        super.tick();
        this.recalculateBoundingBox();
    }

    public void setPos(double x, double y, double z) {
        super.setPos(x, y, z);
        this.recalculateBoundingBox();
    }
}

