/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.monster.dungeon.boss.goal;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.entity.EntityUtil;
import com.aetherteam.aether.entity.monster.dungeon.boss.Slider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class CrushGoal
extends Goal {
    private final Slider slider;

    public CrushGoal(Slider slider) {
        this.slider = slider;
    }

    public boolean canUse() {
        return this.slider.isAwake() && !this.slider.isDeadOrDying() && (this.slider.horizontalCollision || this.slider.verticalCollision || this.blocksBetween(this.slider));
    }

    public boolean canContinueToUse() {
        return false;
    }

    public void start() {
        boolean crushed = false;
        if (EventHooks.canEntityGrief((Level)this.slider.level(), (Entity)this.slider)) {
            AABB crushBox = this.slider.getBoundingBox().inflate(0.2);
            for (BlockPos pos : BlockPos.betweenClosed((int)Mth.floor((double)crushBox.minX), (int)Mth.floor((double)crushBox.minY), (int)Mth.floor((double)crushBox.minZ), (int)Mth.floor((double)crushBox.maxX), (int)Mth.floor((double)crushBox.maxY), (int)Mth.floor((double)crushBox.maxZ))) {
                BlockState blockState;
                if (this.slider.getDungeon() != null && !this.slider.getDungeon().roomBounds().contains(pos.getCenter()) || !this.isBreakable(blockState = this.slider.level().getBlockState(pos))) continue;
                crushed = this.slider.level().destroyBlock(pos, true, (Entity)this.slider) || crushed;
                EntityUtil.spawnRemovalParticles(this.slider.level(), pos);
            }
        }
        if (crushed) {
            this.slider.level().playSound(null, this.slider.blockPosition(), (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.BLOCKS, 3.0f, (0.625f + (this.slider.getRandom().nextFloat() - this.slider.getRandom().nextFloat()) * 0.2f) * 0.7f);
            this.slider.playSound(this.slider.getCollideSound(), 2.5f, 1.0f / (this.slider.getRandom().nextFloat() * 0.2f + 0.9f));
            this.slider.setMoveDelay(this.slider.calculateMoveDelay());
            this.slider.setDeltaMovement(Vec3.ZERO);
        }
    }

    private boolean blocksBetween(Slider slider) {
        LivingEntity target = slider.getTarget();
        if (target == null) {
            return false;
        }
        return slider.level().getBlockStates(AABB.of((BoundingBox)BoundingBox.fromCorners((Vec3i)target.blockPosition(), (Vec3i)slider.blockPosition()))).anyMatch(this::isBreakable);
    }

    private boolean isBreakable(BlockState blockState) {
        return !blockState.isAir() && !blockState.is(AetherTags.Blocks.SLIDER_UNBREAKABLE) && blockState.getBlock().defaultDestroyTime() >= 0.0f && blockState.getBlock().defaultDestroyTime() < 100.0f;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }
}

