/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.sampler.java;

import java.util.ArrayList;
import java.util.Collection;
import me.lucko.spark.common.sampler.java.MergeStrategy;
import me.lucko.spark.common.sampler.node.StackTraceNode;
import me.lucko.spark.common.sampler.node.exporter.AbstractNodeExporter;
import me.lucko.spark.common.sampler.window.ProtoTimeEncoder;
import me.lucko.spark.common.util.MethodDisambiguator;
import me.lucko.spark.proto.SparkSamplerProtos;

public class JavaNodeExporter
extends AbstractNodeExporter {
    private final MergeStrategy mergeStrategy;
    private final MethodDisambiguator methodDisambiguator;

    public JavaNodeExporter(ProtoTimeEncoder timeEncoder, MergeStrategy mergeStrategy, MethodDisambiguator methodDisambiguator) {
        super(timeEncoder);
        this.mergeStrategy = mergeStrategy;
        this.methodDisambiguator = methodDisambiguator;
    }

    @Override
    protected SparkSamplerProtos.StackTraceNode export(StackTraceNode stackTraceNode, Iterable<Integer> childrenRefs) {
        int parentLineNumber;
        double[] times;
        SparkSamplerProtos.StackTraceNode.Builder proto = SparkSamplerProtos.StackTraceNode.newBuilder().setClassName(stackTraceNode.getClassName()).setMethodName(stackTraceNode.getMethodName());
        for (double time : times = stackTraceNode.encodeTimesForProto(this.timeEncoder)) {
            proto.addTimes(time);
        }
        int lineNumber = stackTraceNode.getLineNumber();
        if (lineNumber >= 0) {
            proto.setLineNumber(lineNumber);
        }
        if (this.mergeStrategy.separateParentCalls() && (parentLineNumber = stackTraceNode.getParentLineNumber()) >= 0) {
            proto.setParentLineNumber(parentLineNumber);
        }
        this.methodDisambiguator.disambiguate(stackTraceNode).map(MethodDisambiguator.MethodDescription::getDescription).ifPresent(proto::setMethodDesc);
        proto.addAllChildrenRefs(childrenRefs);
        return (SparkSamplerProtos.StackTraceNode)proto.build();
    }

    @Override
    protected Collection<StackTraceNode> exportChildren(Collection<StackTraceNode> children) {
        if (children.isEmpty()) {
            return children;
        }
        ArrayList<StackTraceNode> list = new ArrayList<StackTraceNode>(children.size());
        block0: for (StackTraceNode child : children) {
            for (StackTraceNode other : list) {
                if (!this.mergeStrategy.shouldMerge(this.methodDisambiguator, other, child)) continue;
                other.merge(child);
                continue block0;
            }
            list.add(child);
        }
        return list;
    }
}

