/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.compat.jei;

import com.jesz.createdieselgenerators.compat.jei.AnimatedDistillationTower;
import com.jesz.createdieselgenerators.content.distillation.DistillationRecipe;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.animations.AnimatedBlazeBurner;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.utility.CreateLang;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

@ParametersAreNonnullByDefault
public class DistillationCategory
extends CreateRecipeCategory<DistillationRecipe> {
    private final AnimatedDistillationTower distillationTower = new AnimatedDistillationTower();
    private final AnimatedBlazeBurner heater = new AnimatedBlazeBurner();

    public DistillationCategory(CreateRecipeCategory.Info<DistillationRecipe> info) {
        super(info);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, DistillationRecipe recipe, IFocusGroup focuses) {
        if (recipe.getFluidIngredients().isEmpty()) {
            return;
        }
        SizedFluidIngredient fluidIngredient = (SizedFluidIngredient)recipe.getFluidIngredients().get(0);
        DistillationCategory.addFluidSlot((IRecipeLayoutBuilder)builder, (int)17, (int)145, (SizedFluidIngredient)fluidIngredient);
        int i = 1;
        for (FluidStack fluidResult : recipe.getFluidResults()) {
            int yPosition = -23 * i + 150;
            DistillationCategory.addFluidSlot((IRecipeLayoutBuilder)builder, (int)130, (int)yPosition, (FluidStack)fluidResult);
            ++i;
        }
        HeatCondition requiredHeat = recipe.getRequiredHeat();
        if (!requiredHeat.testBlazeBurner(BlazeBurnerBlock.HeatLevel.NONE)) {
            builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 134, 171).addItemStack(AllBlocks.BLAZE_BURNER.asStack());
        }
        if (!requiredHeat.testBlazeBurner(BlazeBurnerBlock.HeatLevel.KINDLED)) {
            builder.addSlot(RecipeIngredientRole.CATALYST, 153, 171).addItemStack(AllItems.BLAZE_CAKE.asStack());
        }
    }

    public void draw(DistillationRecipe recipe, IRecipeSlotsView iRecipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        HeatCondition requiredHeat = recipe.getRequiredHeat();
        boolean noHeat = requiredHeat == HeatCondition.NONE;
        AllGuiTextures.JEI_ARROW.render(graphics, 40, 150);
        AllGuiTextures shadow = noHeat ? AllGuiTextures.JEI_SHADOW : AllGuiTextures.JEI_LIGHT;
        shadow.render(graphics, 81, 153 + (noHeat ? 10 : 30));
        this.distillationTower.draw(graphics, 91, 142, recipe.getFluidResults().size());
        if (!noHeat) {
            this.heater.withHeat(requiredHeat.visualizeAsBlazeBurner()).draw(graphics, 91, 150);
        }
        AllGuiTextures heatBar = noHeat ? AllGuiTextures.JEI_NO_HEAT_BAR : AllGuiTextures.JEI_HEAT_BAR;
        heatBar.render(graphics, 4, 170);
        graphics.drawString(Minecraft.getInstance().font, (Component)CreateLang.translateDirect((String)requiredHeat.getTranslationKey(), (Object[])new Object[0]), 9, 176, requiredHeat.getColor(), false);
    }
}

