/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.diesel_engine.modular;

import com.jesz.createdieselgenerators.CDGBlockEntityTypes;
import com.jesz.createdieselgenerators.CDGBlocks;
import com.jesz.createdieselgenerators.CDGConfig;
import com.jesz.createdieselgenerators.content.diesel_engine.EngineUpgrades;
import com.jesz.createdieselgenerators.content.diesel_engine.IEngine;
import com.jesz.createdieselgenerators.content.diesel_engine.modular.ModularDieselEngineBlockEntity;
import com.jesz.createdieselgenerators.content.diesel_engine.normal.DieselEngineBlock;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.placement.PoleHelper;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MilkBucketItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.Nullable;

public class ModularDieselEngineBlock
extends HorizontalKineticBlock
implements IBE<ModularDieselEngineBlockEntity>,
SpecialBlockItemRequirement {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty PIPE = BooleanProperty.create((String)"pipe");
    private static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());

    public ModularDieselEngineBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)super.defaultBlockState().setValue((Property)PIPE, (Comparable)Boolean.valueOf(true))).setValue((Property)DieselEngineBlock.POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return true;
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (oldState.getBlock() == state.getBlock() || isMoving) {
            super.onPlace(state, level, pos, oldState, isMoving);
        }
        this.withBlockEntityDo((BlockGetter)level, pos, ModularDieselEngineBlockEntity::updateConnectivity);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos otherPos, boolean moving) {
        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)DieselEngineBlock.POWERED, (Comparable)Boolean.valueOf(level.hasNeighborSignal(pos))));
        super.neighborChanged(state, level, pos, block, otherPos, moving);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        EngineUpgrades upgrade2;
        IPlacementHelper placementHelper = PlacementHelpers.get((int)placementHelperId);
        if (!player.isShiftKeyDown() && player.mayBuild() && placementHelper.matchesItem(stack)) {
            placementHelper.getOffset(player, level, state, pos, hitResult).placeInWorld(level, (BlockItem)stack.getItem(), player, hand, hitResult);
            return ItemInteractionResult.SUCCESS;
        }
        for (EngineUpgrades upgrade2 : EngineUpgrades.allUpgrades) {
            if (upgrade2 == EngineUpgrades.EMPTY || !upgrade2.getItem().is(stack.getItem())) continue;
            this.withBlockEntityDo((BlockGetter)level, pos, be -> {
                ModularDieselEngineBlockEntity controller = be.getControllerBE();
                if (controller == null || !upgrade2.canAddOn((IEngine)be) || controller.upgrade != EngineUpgrades.EMPTY) {
                    return;
                }
                if (!player.isCreative()) {
                    stack.shrink(1);
                }
                be.upgrade = upgrade2;
                IWrenchable.playRotateSound((Level)level, (BlockPos)pos);
                controller.sendData();
            });
            return ItemInteractionResult.SUCCESS;
        }
        if (!((Boolean)CDGConfig.ENGINES_FILLED_WITH_ITEMS.get()).booleanValue() || stack.isEmpty() || !((upgrade2 = level.getBlockEntity(pos)) instanceof SmartBlockEntity)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        SmartBlockEntity be2 = (SmartBlockEntity)upgrade2;
        IFluidHandler tank = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, be2.getBlockPos(), null);
        if (tank == null) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (stack.getItem() instanceof BucketItem || stack.getItem() instanceof MilkBucketItem) {
            Fluid fluid;
            Item item = stack.getItem();
            if (item instanceof BucketItem) {
                BucketItem bi = (BucketItem)item;
                v0 = bi.content;
            } else {
                v0 = fluid = (Fluid)NeoForgeMod.MILK.get();
            }
            if (!tank.getFluidInTank(0).isEmpty()) {
                return ItemInteractionResult.FAIL;
            }
            tank.fill(new FluidStack(fluid, 1000), IFluidHandler.FluidAction.EXECUTE);
            if (!player.isCreative()) {
                player.setItemInHand(hand, new ItemStack((ItemLike)Items.BUCKET));
            }
            return ItemInteractionResult.SUCCESS;
        }
        IFluidHandlerItem itemTank = (IFluidHandlerItem)Capabilities.FluidHandler.ITEM.getCapability(stack, null);
        if (itemTank == null) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        itemTank.drain(tank.fill(itemTank.getFluidInTank(0), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
        return ItemInteractionResult.SUCCESS;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        if (context.getClickedFace() == Direction.UP) {
            KineticBlockEntity.switchToBlockState((Level)context.getLevel(), (BlockPos)context.getClickedPos(), (BlockState)this.updateAfterWrenched((BlockState)state.setValue((Property)PIPE, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)PIPE) == false)), context));
            IWrenchable.playRotateSound((Level)context.getLevel(), (BlockPos)context.getClickedPos());
            return InteractionResult.SUCCESS;
        }
        this.withBlockEntityDo((BlockGetter)context.getLevel(), context.getClickedPos(), be -> {
            ModularDieselEngineBlockEntity controller = be.getControllerBE();
            if (controller == null || controller.upgrade == EngineUpgrades.EMPTY || context.getLevel().isClientSide()) {
                return;
            }
            if (!context.getPlayer().isCreative()) {
                context.getPlayer().getInventory().placeItemBackInInventory(controller.upgrade.getItem());
            }
            controller.upgrade = EngineUpgrades.EMPTY;
            controller.sendData();
            IWrenchable.playRotateSound((Level)context.getLevel(), (BlockPos)context.getClickedPos());
        });
        return InteractionResult.SUCCESS;
    }

    public BlockState getRotatedBlockState(BlockState originalState, Direction targetedFace) {
        return originalState;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PIPE, DieselEngineBlock.POWERED});
        super.createBlockStateDefinition(builder);
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        if (pContext.getPlayer().isShiftKeyDown()) {
            return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection());
        }
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection().getOpposite());
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!state.is(newState.getBlock())) {
            this.withBlockEntityDo((BlockGetter)level, pos, be -> {
                if (be.upgrade != EngineUpgrades.EMPTY) {
                    ModularDieselEngineBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)be.upgrade.getItem());
                }
            });
        }
        if (state.hasBlockEntity() && (state.getBlock() != newState.getBlock() || !newState.hasBlockEntity()) && (blockEntity = level.getBlockEntity(pos)) instanceof ModularDieselEngineBlockEntity) {
            ModularDieselEngineBlockEntity be2 = (ModularDieselEngineBlockEntity)blockEntity;
            level.removeBlockEntity(pos);
            ConnectivityHandler.splitMulti((BlockEntity)be2);
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public Class<ModularDieselEngineBlockEntity> getBlockEntityClass() {
        return ModularDieselEngineBlockEntity.class;
    }

    public BlockEntityType<? extends ModularDieselEngineBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CDGBlockEntityTypes.MODULAR_DIESEL_ENGINE.get();
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (pState.getValue((Property)FACING) == Direction.NORTH || pState.getValue((Property)FACING) == Direction.SOUTH) {
            return Shapes.or((VoxelShape)Shapes.block(), (VoxelShape)Block.box((double)-2.0, (double)0.0, (double)0.0, (double)18.0, (double)4.0, (double)16.0));
        }
        return Shapes.or((VoxelShape)Shapes.block(), (VoxelShape)Block.box((double)0.0, (double)0.0, (double)-2.0, (double)16.0, (double)4.0, (double)18.0));
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return ((Direction)state.getValue((Property)FACING)).getAxis() == face.getAxis();
    }

    public Direction.Axis getRotationAxis(BlockState blockState) {
        return ((Direction)blockState.getValue((Property)FACING)).getAxis();
    }

    public ItemRequirement getRequiredItems(BlockState state, BlockEntity blockEntity) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(CDGBlocks.MODULAR_DIESEL_ENGINE.asStack());
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, list);
    }

    private static class PlacementHelper
    extends PoleHelper<Direction> {
        public PlacementHelper() {
            super(arg_0 -> CDGBlocks.MODULAR_DIESEL_ENGINE.has(arg_0), state -> ((Direction)state.getValue((Property)FACING)).getAxis(), (Property)FACING);
        }

        public Predicate<ItemStack> getItemPredicate() {
            return arg_0 -> CDGBlocks.MODULAR_DIESEL_ENGINE.isIn(arg_0);
        }
    }
}

