/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.entity_filter;

import com.jesz.createdieselgenerators.CreateDieselGenerators;
import com.jesz.createdieselgenerators.content.entity_filter.ReverseLootTable;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;

public interface EntityAttribute {
    public static final Codec<EntityAttribute> CODEC = RecordCodecBuilder.create(i -> i.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(EntityAttribute::getId), (App)CompoundTag.CODEC.optionalFieldOf("data", (Object)new CompoundTag()).forGetter(EntityAttribute::write)).apply((Applicative)i, (id, data) -> {
        EntityAttribute attribute = EntityAttribute.getById(id);
        if (attribute == null) {
            return null;
        }
        return attribute.read((CompoundTag)data);
    }));
    public static final StreamCodec<ByteBuf, EntityAttribute> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, EntityAttribute::getId, (StreamCodec)ByteBufCodecs.COMPOUND_TAG, EntityAttribute::write, (id, data) -> {
        EntityAttribute attribute = EntityAttribute.getById(id);
        if (attribute == null) {
            return null;
        }
        return attribute.read((CompoundTag)data);
    });
    public static final List<EntityAttribute> all = new LinkedList<EntityAttribute>();
    public static final EntityAttribute STANDARD_TRAITS = EntityAttribute.register(StandardTraits.IS_HOSTILE);
    public static final EntityAttribute IS_MOB = EntityAttribute.register(new IsMob(EntityType.PIG));

    public static EntityAttribute register(EntityAttribute attribute) {
        all.add(attribute);
        return attribute;
    }

    public static EntityAttribute getById(ResourceLocation id) {
        for (EntityAttribute attribute : all) {
            if (!attribute.getId().equals((Object)id)) continue;
            return attribute;
        }
        return null;
    }

    public ResourceLocation getId();

    public boolean test(Entity var1);

    public EntityAttribute read(CompoundTag var1);

    default public CompoundTag write() {
        CompoundTag tag = new CompoundTag();
        tag.putString("Id", this.getId().toString());
        return tag;
    }

    public List<EntityAttribute> listAttributesOf(ItemStack var1);

    public boolean appliesTo(ItemStack var1);

    public Component format(boolean var1);

    default public EntityAttribute register() {
        all.add(this);
        return this;
    }

    public static List<EntityType<?>> getAllEntityTypesFromStack(ItemStack stack) {
        LinkedList list = new LinkedList();
        Item item = stack.getItem();
        if (item instanceof SpawnEggItem) {
            SpawnEggItem item2 = (SpawnEggItem)item;
            list.add(item2.getType(stack));
        }
        for (Map.Entry<Item, List<EntityType<?>>> entry : ReverseLootTable.ALL.entrySet()) {
            if (entry.getKey() != stack.getItem()) continue;
            list.addAll((Collection)entry.getValue());
        }
        return list;
    }

    public static enum StandardTraits implements EntityAttribute
    {
        IS_HOSTILE(e -> e instanceof Monster, stack -> {
            boolean hostile = false;
            for (EntityType<?> type : EntityAttribute.getAllEntityTypesFromStack(stack)) {
                if (type.getCategory() != MobCategory.MONSTER) continue;
                hostile = true;
            }
            return hostile;
        });

        Predicate<ItemStack> itemTest;
        Predicate<Entity> test;

        private StandardTraits(Predicate<Entity> test, Predicate<ItemStack> itemTest) {
            this.test = test;
            this.itemTest = itemTest;
        }

        @Override
        public ResourceLocation getId() {
            return CreateDieselGenerators.rl(this.name().toLowerCase(Locale.ROOT));
        }

        @Override
        public boolean appliesTo(ItemStack stack) {
            return this.itemTest.test(stack);
        }

        @Override
        public boolean test(Entity entity) {
            return this.test.test(entity);
        }

        @Override
        public CompoundTag write() {
            CompoundTag tag = EntityAttribute.super.write();
            tag.putString("TraitType", this.getId().toString());
            return tag;
        }

        @Override
        public EntityAttribute read(CompoundTag tag) {
            StandardTraits attribute = null;
            for (StandardTraits possibleAttribute : StandardTraits.values()) {
                if (!possibleAttribute.getId().toString().equals(tag.getString("TraitType"))) continue;
                attribute = possibleAttribute;
            }
            return attribute;
        }

        @Override
        public List<EntityAttribute> listAttributesOf(ItemStack stack) {
            LinkedList<EntityAttribute> attributes = new LinkedList<EntityAttribute>();
            for (StandardTraits attribute : StandardTraits.values()) {
                if (!attribute.itemTest.test(stack)) continue;
                attributes.add(attribute);
            }
            return attributes;
        }

        @Override
        public Component format(boolean inverted) {
            return CreateDieselGenerators.lang("entity_attributes." + this.getId().getPath() + (inverted ? ".inverted" : ""), new Object[0]);
        }
    }

    public static class IsMob
    implements EntityAttribute {
        EntityType<?> type;

        public IsMob(EntityType<?> type) {
            this.type = type;
        }

        @Override
        public ResourceLocation getId() {
            return CreateDieselGenerators.rl("is_mob");
        }

        @Override
        public boolean test(Entity entity) {
            return entity.getType() == this.type;
        }

        @Override
        public CompoundTag write() {
            CompoundTag tag = EntityAttribute.super.write();
            tag.putString("Entity", BuiltInRegistries.ENTITY_TYPE.getKey(this.type).toString());
            return tag;
        }

        @Override
        public EntityAttribute read(CompoundTag tag) {
            return new IsMob((EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)tag.getString("Entity"))));
        }

        @Override
        public List<EntityAttribute> listAttributesOf(ItemStack stack) {
            LinkedList<EntityAttribute> attributes = new LinkedList<EntityAttribute>();
            for (EntityType<?> type : EntityAttribute.getAllEntityTypesFromStack(stack)) {
                attributes.add(new IsMob(type));
            }
            return attributes;
        }

        @Override
        public boolean appliesTo(ItemStack stack) {
            return !EntityAttribute.getAllEntityTypesFromStack(stack).isEmpty();
        }

        @Override
        public Component format(boolean inverted) {
            return CreateDieselGenerators.lang("entity_attributes.is_mob" + (inverted ? ".inverted" : ""), this.type.getDescription());
        }
    }

    public record EntityAttributeEntry(EntityAttribute attribute, boolean inverted) {
        public static final Codec<EntityAttributeEntry> CODEC = RecordCodecBuilder.create(i -> i.group((App)CODEC.fieldOf("attribute").forGetter(EntityAttributeEntry::attribute), (App)Codec.BOOL.fieldOf("inverted").forGetter(EntityAttributeEntry::inverted)).apply((Applicative)i, EntityAttributeEntry::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, EntityAttributeEntry> STREAM_CODEC = StreamCodec.composite(STREAM_CODEC, EntityAttributeEntry::attribute, (StreamCodec)ByteBufCodecs.BOOL, EntityAttributeEntry::inverted, EntityAttributeEntry::new);

        @Override
        public int hashCode() {
            return Objects.hash(this.inverted, this.attribute.write());
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof EntityAttributeEntry)) {
                return false;
            }
            EntityAttributeEntry entry = (EntityAttributeEntry)obj;
            if (entry.inverted != this.inverted()) {
                return false;
            }
            return entry.attribute.write().equals((Object)this.attribute.write());
        }
    }
}

