/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.tools.lighter;

import com.jesz.createdieselgenerators.CreateDieselGenerators;
import com.jesz.createdieselgenerators.content.tools.lighter.LighterSkinEntry;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.event.ModelEvent;

public class LighterModel {
    private static final List<LighterModel> ALL = new ArrayList<LighterModel>();
    protected final ResourceLocation modelLocation;
    protected BakedModel bakedModel;
    public static Map<String, LighterSkinEntry> lighterSkinModels = new HashMap<String, LighterSkinEntry>();
    public static Map<String, String> lighterSkinIDs = new HashMap<String, String>();

    public LighterModel(ResourceLocation modelLocation) {
        this.modelLocation = modelLocation;
        ALL.add(this);
    }

    public static LighterModel simple(String id, LighterState state) {
        return new LighterModel(CreateDieselGenerators.rl("item/lighter/" + id + state.getSuffix()));
    }

    public static void onModelRegistry(ModelEvent.RegisterAdditional event) {
        for (LighterModel partial : ALL) {
            event.register(new ModelResourceLocation(partial.getLocation(), "standalone"));
        }
    }

    public static void onModelBake(ModelEvent.BakingCompleted event) {
        Map models = event.getModels();
        for (LighterModel partial : ALL) {
            partial.set((BakedModel)models.get(new ModelResourceLocation(partial.getLocation(), "standalone")));
        }
    }

    protected void set(BakedModel bakedModel) {
        this.bakedModel = bakedModel;
    }

    public ResourceLocation getLocation() {
        return this.modelLocation;
    }

    public BakedModel get() {
        return this.bakedModel;
    }

    public static void initSkins() {
        lighterSkinModels.clear();
        lighterSkinModels.put("standard", LighterSkinEntry.STANDARD);
        lighterSkinIDs.forEach((name, id) -> lighterSkinModels.put((String)id, LighterSkinEntry.simple(name, id)));
    }

    public static enum LighterState {
        CLOSED,
        OPEN,
        IGNITED;


        public String getSuffix() {
            if (this == CLOSED) {
                return "";
            }
            return "_" + CreateLang.asId((String)this.name());
        }
    }
}

