/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.client.render.entity.renderer;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.client.render.entity.model.MaulerEntityModel;
import com.faboslav.friendsandfoes.common.entity.MaulerEntity;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesEntityModelLayers;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;

public final class MaulerEntityRenderer
extends MobRenderer<MaulerEntity, MaulerEntityModel<MaulerEntity>> {
    private static final Map<MaulerEntity.Type, ResourceLocation> VARIANT_TEXTURE_MAP = ImmutableMap.of((Object)((Object)MaulerEntity.Type.BADLANDS), (Object)FriendsAndFoes.makeID("textures/entity/mauler/mauler_badlands.png"), (Object)((Object)MaulerEntity.Type.DESERT), (Object)FriendsAndFoes.makeID("textures/entity/mauler/mauler_desert.png"), (Object)((Object)MaulerEntity.Type.SAVANNA), (Object)FriendsAndFoes.makeID("textures/entity/mauler/mauler_savanna.png"));
    private static final float SHADOW_RADIUS = 0.35f;

    public MaulerEntityRenderer(EntityRendererProvider.Context context) {
        super(context, new MaulerEntityModel(context.bakeLayer(FriendsAndFoesEntityModelLayers.MAULER_LAYER)), 0.35f);
    }

    protected float getShadowRadius(MaulerEntity mauler) {
        return mauler.isBurrowedDown() ? 0.0f : 0.35f;
    }

    public ResourceLocation getTextureLocation(MaulerEntity mauler) {
        return VARIANT_TEXTURE_MAP.get((Object)mauler.getMaulerType());
    }
}

