/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.polymorph.mixin;

import com.illusivesoulworks.polymorph.PolymorphConstants;
import com.illusivesoulworks.polymorph.common.integration.PolymorphIntegrations;
import com.illusivesoulworks.polymorph.platform.Services;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.Mixins;
import org.spongepowered.asm.mixin.extensibility.IMixinConfig;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinErrorHandler;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class IntegratedMixinPlugin
implements IMixinConfigPlugin,
IMixinErrorHandler {
    private static final String PREFIX = "com.illusivesoulworks.polymorph.mixin.integration.";
    private static boolean isLoaded = false;

    public void onLoad(String mixinPackage) {
        Mixins.registerErrorHandlerClass((String)"com.illusivesoulworks.polymorph.mixin.IntegratedMixinPlugin");
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (!isLoaded) {
            PolymorphIntegrations.load();
            isLoaded = true;
        }
        if (mixinClassName.startsWith(PREFIX)) {
            String modId = mixinClassName.substring(PREFIX.length()).split("\\.")[0];
            return PolymorphIntegrations.isActive(modId) && Services.PLATFORM.isModFileLoaded(modId);
        }
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void postApply(String s, ClassNode classNode, String s1, IMixinInfo iMixinInfo) {
    }

    public void preApply(String s, ClassNode classNode, String s1, IMixinInfo iMixinInfo) {
    }

    public IMixinErrorHandler.ErrorAction onPrepareError(IMixinConfig config, Throwable th, IMixinInfo mixin, IMixinErrorHandler.ErrorAction action) {
        return null;
    }

    public IMixinErrorHandler.ErrorAction onApplyError(String targetClassName, Throwable th, IMixinInfo mixin, IMixinErrorHandler.ErrorAction action) {
        String pack = mixin.getClassName();
        if (pack.startsWith(PREFIX)) {
            String modId = pack.substring(PREFIX.length(), pack.lastIndexOf(46));
            PolymorphIntegrations.disable(modId);
            PolymorphConstants.LOG.error("Polymorph encountered an error while transforming: {}", (Object)targetClassName);
            PolymorphConstants.LOG.error("The integration module for {} will be disabled.", (Object)modId);
            PolymorphConstants.LOG.error("Please report this bug to Polymorph only, do not report this to {}.", (Object)modId);
            return IMixinErrorHandler.ErrorAction.WARN;
        }
        return null;
    }
}

