/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.jarjar.nio.util.Lazy;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.p3pp3rf1y.sophisticatedstorage.block.ITintableBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;

public class ShulkerBoxItemRenderer
extends BlockEntityWithoutLevelRenderer {
    public static final Lazy<ShulkerBoxItemRenderer> SHULKER_BOX_ITEM_RENDERER = Lazy.of(() -> new ShulkerBoxItemRenderer(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels()));
    private final BlockEntityRenderDispatcher blockEntityRenderDispatcher;
    private final LoadingCache<BlockItem, ShulkerBoxBlockEntity> shulkerBoxBlockEntities = CacheBuilder.newBuilder().maximumSize(512L).weakKeys().build((CacheLoader)new CacheLoader<BlockItem, ShulkerBoxBlockEntity>(this){

        public ShulkerBoxBlockEntity load(BlockItem blockItem) {
            return new ShulkerBoxBlockEntity(BlockPos.ZERO, (BlockState)blockItem.getBlock().defaultBlockState().setValue(ShulkerBoxBlock.FACING, (Comparable)Direction.SOUTH));
        }
    });

    public static IClientItemExtensions getItemRenderProperties() {
        return new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return (BlockEntityWithoutLevelRenderer)SHULKER_BOX_ITEM_RENDERER.get();
            }
        };
    }

    public ShulkerBoxItemRenderer(BlockEntityRenderDispatcher blockEntityRenderDispatcher, EntityModelSet entityModelSet) {
        super(blockEntityRenderDispatcher, entityModelSet);
        this.blockEntityRenderDispatcher = blockEntityRenderDispatcher;
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext transformType, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        BlockEntityRenderer blockentityrenderer;
        Item item = stack.getItem();
        if (!(item instanceof BlockItem)) {
            return;
        }
        BlockItem blockItem = (BlockItem)item;
        ShulkerBoxBlockEntity shulkerBoxBlockEntity = (ShulkerBoxBlockEntity)this.shulkerBoxBlockEntities.getUnchecked((Object)blockItem);
        Item item2 = stack.getItem();
        if (item2 instanceof ITintableBlockItem) {
            ITintableBlockItem tintableBlockItem = (ITintableBlockItem)item2;
            shulkerBoxBlockEntity.getStorageWrapper().setColors(tintableBlockItem.getMainColor(stack).orElse(-1), tintableBlockItem.getAccentColor(stack).orElse(-1));
        }
        if (StorageBlockItem.showsTier(stack) != shulkerBoxBlockEntity.shouldShowTier()) {
            shulkerBoxBlockEntity.toggleTierVisiblity();
        }
        if ((blockentityrenderer = this.blockEntityRenderDispatcher.getRenderer((BlockEntity)shulkerBoxBlockEntity)) != null) {
            blockentityrenderer.render((BlockEntity)shulkerBoxBlockEntity, 0.0f, poseStack, buffer, packedLight, packedOverlay);
        }
    }
}

