/*
 * Decompiled with CFR 0.152.
 */
package cn.mcmod_mmf.mmlib.data.compat;

import cn.mcmod_mmf.mmlib.item.IFoodLike;
import cn.mcmod_mmf.mmlib.item.info.FoodInfo;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.apache.commons.compress.utils.Lists;

public class TFCFoodDefinitionProvider
implements DataProvider {
    protected final PackOutput output;
    protected final String modId;
    protected final ExistingFileHelper existingFileHelper;
    private final ExistingFileHelper.IResourceType resourceType;
    protected final Map<ResourceLocation, FoodInfo> datas = Maps.newLinkedHashMap();

    public TFCFoodDefinitionProvider(PackOutput output, ExistingFileHelper existingFileHelper, String modId) {
        this.output = output;
        this.modId = modId;
        this.existingFileHelper = existingFileHelper;
        this.resourceType = new ExistingFileHelper.ResourceType(PackType.SERVER_DATA, ".json", "tfc/food_items");
    }

    public void addData(Item item) {
        if (item instanceof IFoodLike) {
            IFoodLike food = (IFoodLike)item;
            this.addData(item, food.getFoodInfo());
        }
    }

    public void addData(Item item, FoodInfo data) {
        this.datas.computeIfAbsent(BuiltInRegistries.ITEM.getKey((Object)item), loc -> {
            this.existingFileHelper.trackGenerated(loc, this.resourceType);
            return data;
        });
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        this.datas.clear();
        this.addDatas();
        Path outputFolder = this.output.getOutputFolder();
        ArrayList futureList = Lists.newArrayList();
        this.datas.forEach((loc, data) -> {
            String pathString = String.join((CharSequence)"/", PackType.SERVER_DATA.getDirectory(), this.modId, "tfc", "food_items", loc.getPath() + ".json");
            Path path = outputFolder.resolve(pathString);
            JsonObject jsonObj = new JsonObject();
            jsonObj.addProperty("hunger", (Number)data.getAmount());
            jsonObj.addProperty("saturation", (Number)Float.valueOf(data.getCalories()));
            jsonObj.addProperty("decayModifier", (Number)Float.valueOf(data.getDecayModifier()));
            jsonObj.addProperty("water", (Number)Float.valueOf(data.getWater()));
            jsonObj.addProperty("grain", (Number)Float.valueOf(data.getNutrients()[0]));
            jsonObj.addProperty("fruit", (Number)Float.valueOf(data.getNutrients()[1]));
            jsonObj.addProperty("vegetables", (Number)Float.valueOf(data.getNutrients()[2]));
            jsonObj.addProperty("protein", (Number)Float.valueOf(data.getNutrients()[3]));
            jsonObj.addProperty("dairy", (Number)Float.valueOf(data.getNutrients()[4]));
            futureList.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)jsonObj, (Path)path));
        });
        return CompletableFuture.allOf((CompletableFuture[])futureList.stream().toArray(CompletableFuture[]::new));
    }

    public void addDatas() {
    }

    public String getName() {
        return "MMLib FoodInfo to TFC FoodDefinition Provider";
    }
}

