/*
 * Decompiled with CFR 0.152.
 */
package cn.mcmod_mmf.mmlib.mixin;

import cn.mcmod_mmf.mmlib.mixin.VillagerInvoker;
import cn.mcmod_mmf.mmlib.utils.VillagerUtils;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Villager.class})
public abstract class VillagerMixin
implements VillagerInvoker {
    @Shadow
    private int foodLevel;

    @Inject(method={"wantsToPickUp"}, at={@At(value="TAIL")}, cancellable=true)
    private void onWantsToPickUp(ItemStack stack, CallbackInfoReturnable<Boolean> ci) {
        Item item = stack.getItem();
        boolean result = (Boolean)ci.getReturnValue() != false || VillagerUtils.getFoodPoints().containsKey(item) && ((Villager)this).getInventory().canAddItem(stack);
        ci.setReturnValue((Object)result);
    }

    @Inject(method={"countFoodPointsInInventory"}, at={@At(value="TAIL")}, cancellable=true)
    private void onCountFoodPointsInInventory(CallbackInfoReturnable<Integer> ci) {
        SimpleContainer simplecontainer = ((Villager)this).getInventory();
        int result = VillagerUtils.getFoodPoints().entrySet().stream().mapToInt(p_186300_ -> simplecontainer.countItem((Item)p_186300_.getKey()) * (Integer)p_186300_.getValue()).sum();
        ci.setReturnValue((Object)result);
    }

    @Inject(method={"eatUntilFull"}, at={@At(value="HEAD")}, cancellable=true)
    private void onEatUntilFull(CallbackInfo ci) {
        Villager villager = (Villager)this;
        if (this.hungryInvoker() && this.countFoodPointsInInventoryInvoker() != 0) {
            for (int i = 0; i < villager.getInventory().getContainerSize(); ++i) {
                int j;
                Integer integer;
                ItemStack itemstack = villager.getInventory().getItem(i);
                if (itemstack.isEmpty() || (integer = VillagerUtils.getFoodPoints().get(itemstack.getItem())) == null) continue;
                for (int k = j = itemstack.getCount(); k > 0; --k) {
                    this.foodLevel += integer.intValue();
                    villager.getInventory().removeItem(i, 1);
                    if (this.hungryInvoker()) continue;
                    ci.cancel();
                }
            }
        }
    }
}

