/*
 * Decompiled with CFR 0.152.
 */
package ironfurnaces.gui;

import ironfurnaces.container.BlockWirelessEnergyHeaterContainer;
import ironfurnaces.util.StringHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public abstract class BlockWirelessEnergyHeaterScreenBase<T extends BlockWirelessEnergyHeaterContainer>
extends AbstractContainerScreen<T> {
    public ResourceLocation GUI = ResourceLocation.fromNamespaceAndPath((String)"ironfurnaces", (String)"textures/gui/heater.png");
    Inventory playerInv;
    Component name;

    public BlockWirelessEnergyHeaterScreenBase(T t, Inventory inv, Component name) {
        super(t, inv, name);
        this.playerInv = inv;
        this.name = name;
    }

    protected void init() {
        super.init();
    }

    public void render(GuiGraphics matrix, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(matrix, mouseX, mouseY, partialTicks);
        super.render(matrix, mouseX, mouseY, partialTicks);
        this.renderTooltip(matrix, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics matrix, int mouseX, int mouseY) {
        matrix.drawString(this.font, this.playerInv.getDisplayName(), 7, this.getYSize() - 93, 0x404040, false);
        matrix.drawString(this.font, this.name, this.getXSize() / 2 - this.minecraft.font.width(this.name.getString()) / 2, 6, 0x404040, false);
        int actualMouseX = mouseX - (this.width - this.getXSize()) / 2;
        int actualMouseY = mouseY - (this.height - this.getYSize()) / 2;
        if (actualMouseX >= 68 && actualMouseX <= 108 && actualMouseY >= 64 && actualMouseY <= 76) {
            int energy = ((BlockWirelessEnergyHeaterContainer)this.getMenu()).getEnergy();
            int capacity = ((BlockWirelessEnergyHeaterContainer)this.getMenu()).getMaxEnergy();
            matrix.renderTooltip(this.font, (Component)Component.literal((String)StringHelper.displayEnergy(energy, capacity).get(0)), actualMouseX, actualMouseY);
        }
    }

    protected void renderBg(GuiGraphics matrix, float partialTicks, int mouseX, int mouseY) {
        int relX = (this.width - this.getXSize()) / 2;
        int relY = (this.height - this.getYSize()) / 2;
        matrix.blit(this.GUI, relX, relY, 0, 0, this.getXSize(), this.getYSize());
        int i = ((BlockWirelessEnergyHeaterContainer)this.getMenu()).getEnergyScaled(42);
        matrix.blit(this.GUI, this.getGuiLeft() + 67, this.getGuiTop() + 63, 176, 0, i + 1, 14);
    }
}

