/*
 * Decompiled with CFR 0.152.
 */
package toni.easydisenchanting;

import java.util.HashSet;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AnvilUpdateEvent;
import net.neoforged.neoforge.event.entity.player.AnvilRepairEvent;
import toni.easydisenchanting.foundation.config.AllConfigs;

@EventBusSubscriber(modid="easydisenchanting")
public class AnvilModifier {
    @SubscribeEvent
    public static void onRepair(AnvilRepairEvent event) {
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        if (right.getItem() == Items.BOOK) {
            AnvilModifier.checkGiveItems(event, left, right);
        } else if (left.getItem() == Items.BOOK) {
            AnvilModifier.checkGiveItems(event, right, left);
        } else if (left.getItem() == Items.ENCHANTED_BOOK) {
            AnvilModifier.checkGiveItems(event, right, left);
        }
    }

    private static void checkGiveItems(AnvilRepairEvent event, ItemStack left, ItemStack right) {
        if (!left.isEnchanted() || left.getItem() == Items.ENCHANTED_BOOK) {
            return;
        }
        if ((Integer)AllConfigs.common().return_value.get() == 0) {
            return;
        }
        ItemStack disenchanted = left.copy();
        AnvilModifier.setEnchantments(ItemEnchantments.EMPTY, disenchanted);
        if ((Integer)AllConfigs.common().fixed_value.get() == 0) {
            event.getEntity().giveExperienceLevels(1);
        }
        if (!event.getEntity().getInventory().add(disenchanted)) {
            event.getEntity().drop(disenchanted, true);
        }
    }

    @SubscribeEvent
    public static void onUpdate(AnvilUpdateEvent event) {
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        AnvilModifier.checkUpdate(event, left, right);
        AnvilModifier.checkUpdate(event, right, left);
        AnvilModifier.checkMerge(event, right, left);
    }

    private static void checkUpdate(AnvilUpdateEvent event, ItemStack left, ItemStack right) {
        if (!left.isEnchanted() || left.getItem() == Items.ENCHANTED_BOOK || right.getItem() != Items.BOOK || right.getCount() != 1) {
            return;
        }
        ItemStack finalBook = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
        ItemEnchantments toRemove = AnvilModifier.getEnchantments(left);
        AnvilModifier.setEnchantments(toRemove, finalBook);
        event.setOutput(finalBook);
        event.setCost((long)AnvilModifier.getCost(left, right, toRemove));
    }

    private static void checkMerge(AnvilUpdateEvent event, ItemStack left, ItemStack right) {
        if (!left.isEnchanted() || right.getItem() != Items.ENCHANTED_BOOK || right.getCount() != 1) {
            return;
        }
        ItemStack finalBook = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
        ItemEnchantments toRemove = AnvilModifier.getEnchantments(left);
        ItemEnchantments toMerge = AnvilModifier.getEnchantments(right);
        ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
        HashSet allEnchants = new HashSet();
        allEnchants.addAll(toRemove.keySet());
        allEnchants.addAll(toMerge.keySet());
        for (Holder key : allEnchants) {
            int a = toRemove.getLevel(key);
            int b = toMerge.getLevel(key);
            int combinedLevel = Math.min(((Enchantment)key.value()).getMaxLevel(), a == b ? a + 1 : Math.max(a, b));
            mutable.set(key, combinedLevel);
        }
        ItemEnchantments enchantments = mutable.toImmutable();
        AnvilModifier.setEnchantments(enchantments, finalBook);
        event.setOutput(finalBook);
        event.setCost((long)AnvilModifier.getCost(left, right, enchantments));
    }

    private static int getCost(ItemStack left, ItemStack right, ItemEnchantments enchantsToRemove) {
        int costFactor = 0;
        ItemStack rightCopy = right.copy();
        AnvilModifier.setEnchantments(enchantsToRemove, rightCopy);
        for (Holder enchant : enchantsToRemove.keySet()) {
            if (enchant == null) continue;
            int enchantValue = Math.min(((Enchantment)enchant.value()).getMaxLevel(), enchantsToRemove.getLevel(enchant));
            int rarity = ((Enchantment)enchant.value()).getAnvilCost();
            rarity = Math.max(1, rarity / 2);
            costFactor += rarity * enchantValue;
        }
        Integer fixedValue = (Integer)AllConfigs.common().fixed_value.get();
        double factor_value = (Double)AllConfigs.common().factor_value.get();
        return fixedValue != 1000 ? Math.max(1, fixedValue) : (factor_value > 0.0 ? (int)Math.round((double)costFactor * factor_value) : 1);
    }

    private static ItemEnchantments getEnchantments(ItemStack stack) {
        if (stack.getItem() == Items.ENCHANTED_BOOK) {
            return (ItemEnchantments)stack.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        }
        return (ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
    }

    private static void setEnchantments(ItemEnchantments enchantments, ItemStack stack) {
        if (stack.getItem() == Items.ENCHANTED_BOOK) {
            stack.set(DataComponents.STORED_ENCHANTMENTS, (Object)enchantments);
        } else {
            stack.set(DataComponents.ENCHANTMENTS, (Object)enchantments);
        }
    }
}

