/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.common.registry;

import com.google.common.collect.ImmutableMap;
import com.simibubi.create.api.registry.CreateRegistries;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import plus.dragons.createdragonsplus.common.fluids.dye.DyeColors;
import plus.dragons.createdragonsplus.common.kinetics.fan.coloring.ColoringFanProcessingType;
import plus.dragons.createdragonsplus.common.kinetics.fan.ending.EndingFanProcessingType;
import plus.dragons.createdragonsplus.common.kinetics.fan.freezing.FreezingFanProcessingType;
import plus.dragons.createdragonsplus.common.kinetics.fan.sanding.SandingFanProcessingType;

public class CDPFanProcessingTypes {
    private static final DeferredRegister<FanProcessingType> TYPES = DeferredRegister.create((ResourceKey)CreateRegistries.FAN_PROCESSING_TYPE, (String)"create_dragons_plus");
    public static final Map<DyeColor, Supplier<ColoringFanProcessingType>> COLORING = (Map)Util.make(() -> {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (DyeColor color : DyeColors.ALL) {
            String name = "coloring_" + ResourceLocation.parse((String)color.getName()).getPath();
            DeferredHolder type = TYPES.register(name, () -> new ColoringFanProcessingType(color));
            builder.put((Object)color, (Object)type);
        }
        return builder.build();
    });
    public static final DeferredHolder<FanProcessingType, FreezingFanProcessingType> FREEZING = TYPES.register("freezing", FreezingFanProcessingType::new);
    public static final DeferredHolder<FanProcessingType, SandingFanProcessingType> SANDING = TYPES.register("sanding", SandingFanProcessingType::new);
    public static final DeferredHolder<FanProcessingType, EndingFanProcessingType> ENDING = TYPES.register("ending", EndingFanProcessingType::new);

    public static void register(IEventBus modBus) {
        TYPES.register(modBus);
    }
}

