/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.createframed.registry;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.api.behaviour.interaction.MovingInteractionBehaviour;
import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.content.decoration.TrainTrapdoorBlock;
import com.simibubi.create.content.decoration.palettes.ConnectedGlassPaneBlock;
import com.simibubi.create.content.decoration.palettes.GlassPaneBlock;
import com.simibubi.create.content.decoration.palettes.WindowBlock;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.block.connected.ConnectedTextureBehaviour;
import com.simibubi.create.foundation.block.connected.GlassPaneCTBehaviour;
import com.simibubi.create.foundation.block.connected.HorizontalCTBehaviour;
import com.simibubi.create.foundation.block.connected.SimpleCTBehaviour;
import com.simibubi.create.foundation.data.BuilderTransformers;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.SharedProperties;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import java.util.function.Supplier;
import net.dakotapride.createframed.CreateFramedMod;
import net.dakotapride.createframed.block.ConnectedFramedGlassBlock;
import net.dakotapride.createframed.block.TintedConnectedGlassBlock;
import net.dakotapride.createframed.block.TintedConnectedGlassPaneBlock;
import net.dakotapride.createframed.block.TintedFramedGlassTrapdoorBlock;
import net.dakotapride.createframed.block.TintedGlassPaneBlock;
import net.dakotapride.createframed.block.behaviour.FramedDoorMovingInteraction;
import net.dakotapride.createframed.block.behaviour.FramedGlassTrapdoorCTBehaviour;
import net.dakotapride.createframed.block.behaviour.FramedSlidingDoorMovementBehaviour;
import net.dakotapride.createframed.block.door.FramedGlassSlidingDoorBlock;
import net.dakotapride.createframed.block.door.TintedFramedGlassSlidingDoorBlock;
import net.dakotapride.createframed.registry.CreateFramedTabs;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TintedGlassBlock;
import net.minecraft.world.level.block.TransparentBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;

public class CreateFramedBuilderTransformers {
    private static final CreateRegistrate REGISTRATE = CreateFramedMod.REGISTRATE.setCreativeTab(CreateFramedTabs.CREATE_FRAMED);

    public static BlockEntry<WindowBlock> windowBlock(String name, Supplier<ConnectedTextureBehaviour> behaviour, Block block) {
        return ((BlockBuilder)REGISTRATE.block(name + "_window", p -> new WindowBlock(p, false)).onRegister(CreateRegistrate.connectedTextures(behaviour))).addLayer(() -> RenderType::cutout).initialProperties(() -> Blocks.GLASS).properties(p -> p.isValidSpawn(CreateFramedBuilderTransformers::never).isRedstoneConductor(CreateFramedBuilderTransformers::never).isSuffocating(CreateFramedBuilderTransformers::never).isViewBlocking(CreateFramedBuilderTransformers::never).noOcclusion().mapColor(block.defaultMapColor())).simpleItem().register();
    }

    public static BlockEntry<ConnectedGlassPaneBlock> windowPaneBlock(String name, Supplier<CTSpriteShiftEntry> ct, Supplier<MapColor> color) {
        return ((BlockBuilder)REGISTRATE.block(name + "_window_pane", ConnectedGlassPaneBlock::new).onRegister(CreateRegistrate.connectedTextures(() -> new HorizontalCTBehaviour((CTSpriteShiftEntry)ct.get())))).addLayer(() -> RenderType::cutout).initialProperties(() -> Blocks.GLASS_PANE).properties(p -> p.mapColor((MapColor)color.get()).noOcclusion()).simpleItem().register();
    }

    public static BlockEntry<WindowBlock> roseQuartzWindowBlock(String name, Supplier<ConnectedTextureBehaviour> behaviour, Block block) {
        return ((BlockBuilder)REGISTRATE.block(name + "_window", p -> new WindowBlock(p, false)).onRegister(CreateRegistrate.connectedTextures(behaviour))).addLayer(() -> RenderType::translucent).initialProperties(() -> Blocks.GLASS).properties(p -> p.isValidSpawn(CreateFramedBuilderTransformers::never).isRedstoneConductor(CreateFramedBuilderTransformers::never).isSuffocating(CreateFramedBuilderTransformers::never).isViewBlocking(CreateFramedBuilderTransformers::never).noOcclusion().mapColor(block.defaultMapColor())).simpleItem().register();
    }

    public static BlockEntry<ConnectedGlassPaneBlock> roseQuartzWindowPaneBlock(String name, Supplier<CTSpriteShiftEntry> ct, Supplier<MapColor> color) {
        return ((BlockBuilder)REGISTRATE.block(name + "_window_pane", ConnectedGlassPaneBlock::new).onRegister(CreateRegistrate.connectedTextures(() -> new HorizontalCTBehaviour((CTSpriteShiftEntry)ct.get())))).addLayer(() -> RenderType::translucent).initialProperties(() -> Blocks.GLASS_PANE).properties(p -> p.mapColor((MapColor)color.get()).noOcclusion()).simpleItem().register();
    }

    public static BlockEntry<ConnectedFramedGlassBlock> verticalColouredFramedGlass(String name, Supplier<ConnectedTextureBehaviour> behaviour, Block stainedBlock, DyeColor dyeColour) {
        return CreateFramedBuilderTransformers.colouredFramedGlass("vertical_" + name, behaviour, stainedBlock, dyeColour);
    }

    public static BlockEntry<ConnectedFramedGlassBlock> horizontalColouredFramedGlass(String name, Supplier<ConnectedTextureBehaviour> behaviour, Block stainedBlock, DyeColor dyeColour) {
        return CreateFramedBuilderTransformers.colouredFramedGlass("horizontal_" + name, behaviour, stainedBlock, dyeColour);
    }

    public static BlockEntry<ConnectedFramedGlassBlock> colouredFramedGlass(String name, Supplier<ConnectedTextureBehaviour> behaviour, Block stainedBlock, DyeColor dyeColour) {
        return ((BlockBuilder)REGISTRATE.block(name + "_stained_framed_glass", p -> new ConnectedFramedGlassBlock(dyeColour, (BlockBehaviour.Properties)p)).onRegister(CreateRegistrate.connectedTextures(behaviour))).addLayer(() -> RenderType::translucent).initialProperties(() -> stainedBlock).properties(p -> p.isValidSpawn(CreateFramedBuilderTransformers::never).isRedstoneConductor(CreateFramedBuilderTransformers::never).isSuffocating(CreateFramedBuilderTransformers::never).isViewBlocking(CreateFramedBuilderTransformers::never).noOcclusion()).simpleItem().register();
    }

    public static BlockEntry<TransparentBlock> colouredTiledGlass(String colourType) {
        return REGISTRATE.block(colourType + "_stained_tiled_glass", TransparentBlock::new).initialProperties(() -> Blocks.GLASS).addLayer(() -> RenderType::translucent).simpleItem().register();
    }

    public static BlockEntry<GlassPaneBlock> colouredTiledGlassPane(String colourType) {
        return REGISTRATE.block(colourType + "_stained_tiled_glass_pane", GlassPaneBlock::new).initialProperties(() -> Blocks.GLASS_PANE).addLayer(() -> RenderType::translucent).simpleItem().register();
    }

    public static BlockEntry<TintedGlassBlock> tintedTiledGlass() {
        return REGISTRATE.block("tinted_tiled_glass", TintedGlassBlock::new).initialProperties(() -> Blocks.TINTED_GLASS).addLayer(() -> RenderType::translucent).simpleItem().register();
    }

    public static BlockEntry<TintedGlassPaneBlock> tintedTiledGlassPane() {
        return REGISTRATE.block("tinted_tiled_glass_pane", TintedGlassPaneBlock::new).initialProperties(() -> Blocks.GLASS_PANE).addLayer(() -> RenderType::translucent).simpleItem().register();
    }

    public static <B extends FramedGlassSlidingDoorBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> slidingDoor(String type) {
        return b -> ((BlockBuilder)((BlockBuilder)b.initialProperties(() -> Blocks.OAK_DOOR).properties(p -> p.strength(3.0f, 6.0f).isViewBlocking(CreateFramedBuilderTransformers::never)).addLayer(() -> RenderType::translucent).onRegister(MovingInteractionBehaviour.interactionBehaviour((MovingInteractionBehaviour)new FramedDoorMovingInteraction()))).onRegister(MovementBehaviour.movementBehaviour((MovementBehaviour)new FramedSlidingDoorMovementBehaviour()))).simpleItem();
    }

    public static <B extends TintedFramedGlassSlidingDoorBlock, P> NonNullUnaryOperator<BlockBuilder<B, P>> tintedSlidingDoor(String type) {
        return b -> (BlockBuilder)((BlockBuilder)((BlockBuilder)b.initialProperties(() -> Blocks.OAK_DOOR).properties(p -> p.strength(3.0f, 6.0f).isViewBlocking(CreateFramedBuilderTransformers::never)).addLayer(() -> RenderType::translucent).onRegister(MovingInteractionBehaviour.interactionBehaviour((MovingInteractionBehaviour)new FramedDoorMovingInteraction()))).onRegister(MovementBehaviour.movementBehaviour((MovementBehaviour)new FramedSlidingDoorMovementBehaviour()))).item().build();
    }

    public static BlockEntry<FramedGlassSlidingDoorBlock> framedGlassSlidingDoor(String type, MapColor colour) {
        return ((BlockBuilder)REGISTRATE.block(type + "_stained_framed_glass_door", FramedGlassSlidingDoorBlock::new).initialProperties((NonNullSupplier)AllBlocks.FRAMED_GLASS_DOOR).properties(p -> p.sound(SoundType.GLASS).mapColor(colour).noOcclusion()).transform(CreateFramedBuilderTransformers.slidingDoor(type))).register();
    }

    public static BlockEntry<TintedFramedGlassSlidingDoorBlock> tintedFramedGlassSlidingDoor(String type, MapColor colour) {
        return ((BlockBuilder)REGISTRATE.block(type + "_door", TintedFramedGlassSlidingDoorBlock::new).initialProperties((NonNullSupplier)AllBlocks.FRAMED_GLASS_DOOR).properties(p -> p.sound(SoundType.GLASS).mapColor(colour).noOcclusion()).transform(CreateFramedBuilderTransformers.tintedSlidingDoor(type))).register();
    }

    public static BlockEntry<TrainTrapdoorBlock> framedGlassTrapdoor(String name, MapColor colour, CTSpriteShiftEntry spriteShiftEntry) {
        return ((BlockBuilder)((BlockBuilder)REGISTRATE.block(name + "_stained_framed_glass_trapdoor", TrainTrapdoorBlock::new).initialProperties(SharedProperties::softMetal).transform((NonNullFunction)BuilderTransformers.trapdoor((boolean)false))).properties(p -> p.sound(SoundType.GLASS).noOcclusion().mapColor(colour)).onRegister(CreateRegistrate.connectedTextures(() -> new FramedGlassTrapdoorCTBehaviour(spriteShiftEntry)))).addLayer(() -> RenderType::translucent).register();
    }

    public static BlockEntry<TintedFramedGlassTrapdoorBlock> tintedFramedGlassTrapdoor(String name, MapColor colour, CTSpriteShiftEntry spriteShiftEntry) {
        return ((BlockBuilder)((BlockBuilder)REGISTRATE.block(name + "_trapdoor", TintedFramedGlassTrapdoorBlock::new).initialProperties(SharedProperties::softMetal).transform((NonNullFunction)BuilderTransformers.trapdoor((boolean)false))).properties(p -> p.sound(SoundType.GLASS).noOcclusion().mapColor(colour)).onRegister(CreateRegistrate.connectedTextures(() -> new FramedGlassTrapdoorCTBehaviour(spriteShiftEntry)))).addLayer(() -> RenderType::translucent).register();
    }

    public static BlockEntry<ConnectedGlassPaneBlock> verticalColouredFramedGlassPane(String name, Supplier<Block> stainedBlock, Supplier<CTSpriteShiftEntry> behaviour) {
        return CreateFramedBuilderTransformers.colouredFramedGlassPane("vertical_" + name, stainedBlock, behaviour);
    }

    public static BlockEntry<ConnectedGlassPaneBlock> horizontalColouredFramedGlassPane(String name, Supplier<Block> stainedBlock, Supplier<CTSpriteShiftEntry> behaviour) {
        return CreateFramedBuilderTransformers.colouredFramedGlassPane("horizontal_" + name, stainedBlock, behaviour);
    }

    public static BlockEntry<ConnectedGlassPaneBlock> colouredFramedGlassPane(String name, Supplier<? extends Block> parent, Supplier<CTSpriteShiftEntry> ctshift) {
        Supplier<Supplier<RenderType>> renderType = () -> RenderType::translucent;
        return CreateFramedBuilderTransformers.connectedGlassPane(name + "_stained_framed_glass", parent, ctshift, renderType);
    }

    public static BlockEntry<TintedConnectedGlassPaneBlock> tintedFramedGlassPane(String name, Supplier<? extends Block> parent, Supplier<CTSpriteShiftEntry> ctshift) {
        Supplier<Supplier<RenderType>> renderType = () -> RenderType::translucent;
        return CreateFramedBuilderTransformers.tintedConnectedGlassPane(name, parent, ctshift, renderType);
    }

    public static BlockEntry<TintedConnectedGlassBlock> tintedFramedGlass(CTSpriteShiftEntry entry) {
        return ((BlockBuilder)((BlockBuilder)REGISTRATE.block("tinted_framed_glass", TintedConnectedGlassBlock::new).onRegister(CreateRegistrate.connectedTextures(() -> new SimpleCTBehaviour(entry)))).addLayer(() -> RenderType::translucent).initialProperties(() -> Blocks.TINTED_GLASS).properties(p -> p.isValidSpawn(CreateFramedBuilderTransformers::never).isRedstoneConductor(CreateFramedBuilderTransformers::never).isSuffocating(CreateFramedBuilderTransformers::never).isViewBlocking(CreateFramedBuilderTransformers::never).noOcclusion()).item().build()).register();
    }

    public static BlockEntry<TintedConnectedGlassBlock> tintedFramedGlass(String name, ConnectedTextureBehaviour.Base behaviour) {
        return ((BlockBuilder)((BlockBuilder)REGISTRATE.block(name + "_tinted_framed_glass", TintedConnectedGlassBlock::new).onRegister(CreateRegistrate.connectedTextures(() -> behaviour))).addLayer(() -> RenderType::translucent).initialProperties(() -> Blocks.TINTED_GLASS).properties(p -> p.isValidSpawn(CreateFramedBuilderTransformers::never).isRedstoneConductor(CreateFramedBuilderTransformers::never).isSuffocating(CreateFramedBuilderTransformers::never).isViewBlocking(CreateFramedBuilderTransformers::never).noOcclusion()).item().build()).register();
    }

    public static boolean never(BlockState p_235436_0_, BlockGetter p_235436_1_, BlockPos p_235436_2_) {
        return false;
    }

    public static Boolean never(BlockState p_235427_0_, BlockGetter p_235427_1_, BlockPos p_235427_2_, EntityType<?> p_235427_3_) {
        return false;
    }

    private static BlockEntry<ConnectedGlassPaneBlock> connectedGlassPane(String name, Supplier<? extends Block> parent, Supplier<CTSpriteShiftEntry> ctshift, Supplier<Supplier<RenderType>> renderType) {
        NonNullConsumer connectedTextures = CreateRegistrate.connectedTextures(() -> new GlassPaneCTBehaviour((CTSpriteShiftEntry)ctshift.get()));
        return CreateFramedBuilderTransformers.glassPane(name, parent, ConnectedGlassPaneBlock::new, renderType, connectedTextures);
    }

    private static BlockEntry<TintedConnectedGlassPaneBlock> tintedConnectedGlassPane(String name, Supplier<? extends Block> parent, Supplier<CTSpriteShiftEntry> ctshift, Supplier<Supplier<RenderType>> renderType) {
        NonNullConsumer connectedTextures = CreateRegistrate.connectedTextures(() -> new GlassPaneCTBehaviour((CTSpriteShiftEntry)ctshift.get()));
        return CreateFramedBuilderTransformers.glassPane(name, parent, TintedConnectedGlassPaneBlock::new, renderType, connectedTextures);
    }

    private static <G extends GlassPaneBlock> BlockEntry<G> glassPane(String name, Supplier<? extends Block> parent, NonNullFunction<BlockBehaviour.Properties, G> factory, Supplier<Supplier<RenderType>> renderType, NonNullConsumer<? super G> connectedTextures) {
        name = (String)name + "_pane";
        return ((BlockBuilder)REGISTRATE.block((String)name, factory).onRegister(connectedTextures)).addLayer(renderType).initialProperties(() -> Blocks.GLASS_PANE).properties(p -> p.mapColor(((Block)parent.get()).defaultMapColor())).simpleItem().register();
    }
}

