/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.cuisinedelight.content.logic;

import dev.xkmc.cuisinedelight.content.logic.IngredientConfig;
import dev.xkmc.cuisinedelight.content.logic.transform.Stage;
import dev.xkmc.l2serial.serialization.marker.SerialClass;
import dev.xkmc.l2serial.serialization.marker.SerialField;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.world.item.ItemStack;

@SerialClass
public class CookingData {
    @SerialField
    private long lastActionTime;
    @SerialField
    private float speed = 1.0f;
    @SerialField
    public ArrayList<CookingEntry> contents = new ArrayList();

    public void update(long time) {
        this.lastActionTime = time;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public void stir(long time, int reduce) {
        this.update(time);
        for (CookingEntry entry : this.contents) {
            entry.stir(time, reduce);
        }
    }

    public void addItem(ItemStack item, long time) {
        this.update(time);
        this.contents.add(new CookingEntry(item, time));
    }

    public Record immutable() {
        ArrayList<CookingEntry.Immutable> list = new ArrayList<CookingEntry.Immutable>();
        for (CookingEntry e : this.contents) {
            list.add(e.immutable());
        }
        return new Record(this.lastActionTime, this.speed, list);
    }

    @SerialClass
    public static class CookingEntry {
        @SerialField
        private ItemStack item;
        @SerialField
        private long startTime;
        @SerialField
        private long lastStirTime;
        @SerialField
        private int maxStirTime;

        @Deprecated
        public CookingEntry() {
        }

        public CookingEntry(ItemStack item, long time) {
            this.item = item;
            this.startTime = time;
            this.lastStirTime = time;
            this.maxStirTime = 0;
        }

        public void stir(long time, int reduce) {
            this.maxStirTime = Math.max(this.maxStirTime, (int)(time - this.lastStirTime));
            this.lastStirTime = time + (long)reduce;
        }

        public float getDuration(CookingData data, float partialTick) {
            return (partialTick + (float)data.lastActionTime - (float)this.startTime) * data.speed;
        }

        public float timeSinceStir(CookingData data, float partialTick) {
            return Math.max(0.0f, partialTick + (float)data.lastActionTime - (float)this.lastStirTime) * data.speed;
        }

        public float getMaxStirTime(CookingData data) {
            return (float)this.maxStirTime * data.speed;
        }

        public ItemStack getItem() {
            return this.item;
        }

        public long seed() {
            return new Random(this.startTime).nextLong();
        }

        public Stage getStage(CookingData data) {
            IngredientConfig.IngredientEntry config = IngredientConfig.get().getEntry(this.getItem());
            assert (config != null);
            float time = this.getDuration(data, 0.0f);
            if (time < (float)config.min_time) {
                return Stage.RAW;
            }
            if (time < (float)config.max_time) {
                return Stage.COOKED;
            }
            return Stage.OVERCOOKED;
        }

        public Immutable immutable() {
            return new Immutable(this.item, this.startTime, this.lastStirTime, this.maxStirTime);
        }

        public record Immutable(ItemStack item, long startTime, long lastStirTime, int maxStirTime) {
            public CookingEntry mutable() {
                CookingEntry ans = new CookingEntry();
                ans.item = this.item;
                ans.startTime = this.startTime;
                ans.lastStirTime = this.lastStirTime;
                ans.maxStirTime = this.maxStirTime;
                return ans;
            }
        }
    }

    public record Record(long lastActionTime, float speed, ArrayList<CookingEntry.Immutable> contents) {
        public CookingData mutable() {
            CookingData ans = new CookingData();
            ans.lastActionTime = this.lastActionTime;
            ans.speed = this.speed;
            for (CookingEntry.Immutable e : this.contents) {
                ans.contents.add(e.mutable());
            }
            return ans;
        }
    }
}

