/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.screen.widget;

import com.tom.storagemod.screen.widget.IconButton;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class EnumCycleButton<T extends Enum<T>>
extends IconButton {
    private T state;
    public Function<T, Tooltip> tooltipFactory;
    public Function<T, ResourceLocation> icon = e -> ResourceLocation.tryBuild((String)"toms_storage", (String)("icons/" + prefix + "_" + e.name().toLowerCase(Locale.ROOT)));

    public EnumCycleButton(int x, int y, Component name, String prefix, T[] el, Consumer<T> stateUpdate) {
        super(x, y, name, null, EnumCycleButton.onPress(el, stateUpdate));
    }

    protected MutableComponent createNarrationMessage() {
        return EnumCycleButton.wrapDefaultNarrationMessage((Component)this.name.copy().append(" ").append((Component)Component.translatable((String)("narrator.toms_storage.button_state." + ((Enum)this.state).name().toLowerCase(Locale.ROOT)))));
    }

    @Override
    public ResourceLocation getIcon() {
        return this.icon.apply(this.state);
    }

    public void setState(T state) {
        if (this.state != state && this.tooltipFactory != null) {
            this.setTooltip(this.tooltipFactory.apply(state));
        }
        this.state = state;
    }

    public T getState() {
        return this.state;
    }

    private static <T extends Enum<T>> Button.OnPress onPress(T[] el, Consumer<T> stateUpdate) {
        return b -> stateUpdate.accept(el[(((Enum)((EnumCycleButton)b).getState()).ordinal() + el.length + (Screen.hasShiftDown() ? -1 : 1)) % el.length]);
    }
}

