/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.message;

import com.github.L_Ender.cataclysm.client.sound.SandstormSound;
import com.github.L_Ender.cataclysm.entity.effect.Sandstorm_Entity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record MessageSandstormSound(int entityID, boolean play) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<MessageSandstormSound> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"cataclysm", (String)"sandstorm_sound"));
    public static final StreamCodec<RegistryFriendlyByteBuf, MessageSandstormSound> STREAM_CODEC = CustomPacketPayload.codec(MessageSandstormSound::write, MessageSandstormSound::new);

    public MessageSandstormSound(FriendlyByteBuf buf) {
        this(buf.readInt(), buf.readBoolean());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.entityID());
        buf.writeBoolean(this.play());
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(final MessageSandstormSound message, final IPayloadContext ctx) {
        if (ctx.flow().isClientbound()) {
            ctx.enqueueWork(new Runnable(){

                @Override
                public void run() {
                    Entity entity = ctx.player().level().getEntity(message.entityID());
                    if (entity instanceof Sandstorm_Entity) {
                        Sandstorm_Entity living = (Sandstorm_Entity)entity;
                        Minecraft.getInstance().getSoundManager().queueTickingSound((TickableSoundInstance)new SandstormSound(living));
                    }
                }
            });
        }
    }
}

