/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.next.env.param;

import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.sinytra.adapter.patch.analysis.params.LayeredParamsDiffSnapshot;

public class ParamDiffResolver {
    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ParamEvalResult resolve(List<Type> input, LayeredParamsDiffSnapshot diff) {
        ArrayList<PositionedParam> state = new ArrayList<PositionedParam>();
        for (int i = 0; i < input.size(); ++i) {
            Type type = input.get(i);
            state.add(new PositionedParam(i, type));
        }
        Iterator<LayeredParamsDiffSnapshot.ParamModification> i = diff.modifications().iterator();
        block16: while (i.hasNext()) {
            LayeredParamsDiffSnapshot.ParamModification modification;
            LayeredParamsDiffSnapshot.ParamModification paramModification = modification = i.next();
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LayeredParamsDiffSnapshot.InsertParam.class, LayeredParamsDiffSnapshot.ReplaceParam.class, LayeredParamsDiffSnapshot.SwapParam.class, LayeredParamsDiffSnapshot.MoveParam.class, LayeredParamsDiffSnapshot.RemoveParam.class, LayeredParamsDiffSnapshot.InlineParam.class, LayeredParamsDiffSnapshot.SubstituteParam.class}, (Object)paramModification, n)) {
                case 0: {
                    LayeredParamsDiffSnapshot.ReplaceParam replaceParam;
                    LayeredParamsDiffSnapshot.InsertParam insertParam = (LayeredParamsDiffSnapshot.InsertParam)paramModification;
                    try {
                        int n2;
                        int index = n2 = insertParam.index();
                        LayeredParamsDiffSnapshot.ReplaceParam type = replaceParam = insertParam.type();
                        state.add(index, new PositionedParam(-1, (Type)type));
                        continue block16;
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                }
                case 1: {
                    LayeredParamsDiffSnapshot.SwapParam swapParam;
                    LayeredParamsDiffSnapshot.ReplaceParam replaceParam = (LayeredParamsDiffSnapshot.ReplaceParam)paramModification;
                    {
                        int n3;
                        int index = n3 = replaceParam.index();
                        LayeredParamsDiffSnapshot.SwapParam type = swapParam = replaceParam.type();
                        ((PositionedParam)state.get((int)index)).type = type;
                        continue block16;
                    }
                }
                case 2: {
                    int to;
                    int from;
                    LayeredParamsDiffSnapshot.SwapParam swapParam = (LayeredParamsDiffSnapshot.SwapParam)paramModification;
                    {
                        int n4;
                        from = n4 = swapParam.from();
                        to = n4 = swapParam.to();
                    }
                    PositionedParam clean = (PositionedParam)state.get(from);
                    PositionedParam dirty = (PositionedParam)state.get(to);
                    state.set(from, dirty);
                    state.set(to, clean);
                    continue block16;
                }
                case 3: {
                    LayeredParamsDiffSnapshot.MoveParam moveParam = (LayeredParamsDiffSnapshot.MoveParam)paramModification;
                    {
                        int n5;
                        int from = n5 = moveParam.from();
                        int to = n5 = moveParam.to();
                        state.add(to, (PositionedParam)state.remove(from));
                        continue block16;
                    }
                }
                case 4: {
                    LayeredParamsDiffSnapshot.RemoveParam removeParam = (LayeredParamsDiffSnapshot.RemoveParam)paramModification;
                    {
                        int n6;
                        int index = n6 = removeParam.index();
                        state.remove(index);
                    }
                    continue block16;
                }
                case 5: {
                    LayeredParamsDiffSnapshot.InlineParam inline = (LayeredParamsDiffSnapshot.InlineParam)paramModification;
                    state.remove(inline.target());
                    continue block16;
                }
                case 6: {
                    LayeredParamsDiffSnapshot.SubstituteParam substitute = (LayeredParamsDiffSnapshot.SubstituteParam)paramModification;
                    state.remove(substitute.target());
                    continue block16;
                }
            }
            throw new RuntimeException("Unknown parameter modification: " + String.valueOf(modification));
        }
        ArrayList<ParamState> result = new ArrayList<ParamState>(state.size());
        int i2 = 0;
        while (i2 < state.size()) {
            PositionedParam param = (PositionedParam)state.get(i2);
            result.add(new ParamState(param.type, param.cleanPos, i2));
            ++i2;
        }
        return new ParamEvalResult(input, result);
    }

    private static class PositionedParam {
        private final int cleanPos;
        private Type type;

        public PositionedParam(int cleanPos, Type type) {
            this.cleanPos = cleanPos;
            this.type = type;
        }
    }

    public record ParamState(Type type, int cleanIndex, int dirtyIndex) {
    }

    public static class ParamEvalResult {
        private final List<Type> original;
        private final Map<Integer, ParamState> params;

        public ParamEvalResult(List<Type> original, List<ParamState> params) {
            this.original = new ReferenceArrayList(original);
            this.params = params.stream().filter(s -> s.cleanIndex != -1).collect(Collectors.toUnmodifiableMap(p -> p.cleanIndex, Function.identity()));
        }

        @Nullable
        public ParamState getUpdated(Type param) {
            int oldIndex = this.original.indexOf(param);
            return oldIndex == -1 ? null : this.params.get(oldIndex);
        }
    }
}

