/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.api;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.InstructionAdapter;
import org.objectweb.asm.tree.ClassNode;
import org.sinytra.adapter.patch.ClassPatchInstance;
import org.sinytra.adapter.patch.InterfacePatchInstance;
import org.sinytra.adapter.patch.PatchInstance;
import org.sinytra.adapter.patch.analysis.selector.AnnotationHandle;
import org.sinytra.adapter.patch.analysis.selector.AnnotationValueHandle;
import org.sinytra.adapter.patch.api.ClassTransform;
import org.sinytra.adapter.patch.api.MethodTransformBuilder;
import org.sinytra.adapter.patch.api.PatchEnvironment;

public interface Patch {
    public static ClassPatchBuilder builder() {
        return new ClassPatchInstance.ClassPatchBuilderImpl();
    }

    public static InterfacePatchBuilder interfaceBuilder() {
        return new InterfacePatchInstance.InterfaceClassPatchBuilderImpl();
    }

    public Result apply(ClassNode var1, PatchEnvironment var2);

    public static interface InterfacePatchBuilder
    extends Builder<InterfacePatchBuilder> {
        public InterfacePatchBuilder targetField(String ... var1);
    }

    public static interface ClassPatchBuilder
    extends Builder<ClassPatchBuilder>,
    MethodTransformBuilder.Class<ClassPatchBuilder> {
        public ClassPatchBuilder targetMethod(String ... var1);

        default public ClassPatchBuilder targetInjectionPoint(String target) {
            return this.targetInjectionPoint(null, target);
        }

        public ClassPatchBuilder targetInjectionPoint(String var1, String var2);

        default public ClassPatchBuilder targetConstant(double doubleValue) {
            return (ClassPatchBuilder)this.targetAnnotationValues(handle -> handle.getNested("constant").flatMap(cst -> cst.getValue("doubleValue").map(val -> (Double)val.get() == doubleValue)).orElseGet(() -> handle.getNested("at").flatMap(at -> at.getValue("value").map(s -> ((String)s.get()).equals("CONSTANT") && at.getValue("args").map(AnnotationValueHandle::get).map(t -> t.size() == 1 && (((String)t.getFirst()).equals("doubleValue=" + doubleValue + "D") || ((String)t.getFirst()).equals("doubleValue=" + doubleValue))).orElse(false) != false)).orElse(false)));
        }

        public ClassPatchBuilder divertRedirector(Consumer<InstructionAdapter> var1);

        public ClassPatchBuilder disable();
    }

    public static interface Builder<T extends Builder<T>>
    extends MethodTransformBuilder<T> {
        public T targetClass(String ... var1);

        public T targetMixinType(String ... var1);

        public T targetAnnotationValues(Predicate<AnnotationHandle> var1);

        public T modifyTargetClasses(Consumer<List<Type>> var1);

        public T transform(List<ClassTransform> var1);

        public T transform(ClassTransform var1);

        public PatchInstance build();
    }

    public static enum Result {
        PASS,
        APPLY,
        COMPUTE_FRAMES;


        public Result or(Result other) {
            if (this == PASS && other != PASS) {
                return other;
            }
            if (this == APPLY && other == COMPUTE_FRAMES) {
                return COMPUTE_FRAMES;
            }
            return this;
        }
    }
}

