/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.content.nuclear.reactor.vent;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.antarcticgardens.cna.config.CNAConfig;
import org.antarcticgardens.cna.content.heat.HeatBlockEntity;
import org.antarcticgardens.cna.content.nuclear.reactor.RodFindingReactorBlockEntity;
import org.antarcticgardens.cna.content.nuclear.reactor.rod.ReactorRodBlockEntity;
import org.antarcticgardens.cna.util.StringFormatUtil;

public class ReactorHeatVentBlockEntity
extends RodFindingReactorBlockEntity
implements HeatBlockEntity,
IHaveGoggleInformation {
    private float extract;
    public float heat = 0.0f;
    int tick = 0;

    public ReactorHeatVentBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        this.heat = tag.getFloat("heat");
        this.extract = tag.getFloat("extract");
        super.read(tag, registries, clientPacket);
    }

    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        tag.putFloat("heat", this.heat);
        tag.putFloat("extract", this.extract);
        super.write(tag, registries, clientPacket);
    }

    @Override
    public boolean canConnect(Direction from) {
        return from != this.getBlockState().getValue((Property)BlockStateProperties.FACING);
    }

    @Override
    public float getHeat() {
        return this.heat;
    }

    @Override
    public void addHeat(float amount) {
        this.heat += amount;
        this.setChanged();
    }

    @Override
    public void setHeat(float amount) {
        this.heat = amount;
        this.setChanged();
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void tick(BlockPos pos, Level world, BlockState state) {
        ++this.tick;
        if (this.tick >= 20) {
            double multiplier = (Double)CNAConfig.getCommon().overheatingMultiplier.get();
            HeatBlockEntity.handleOverheat(this);
            this.tick = 0;
            this.extract = 0.0f;
            ReactorHeatVentBlockEntity.transferAroundNonRodOnly(this);
            LinkedList<ReactorRodBlockEntity> rods = new LinkedList<ReactorRodBlockEntity>();
            for (Direction dir : Direction.values()) {
                this.findRods(rods, dir);
            }
            for (ReactorRodBlockEntity rod : rods) {
                float total = Math.min(rod.heat, 10000.0f - this.heat);
                rod.heat -= total;
                if (total > 0.0f) {
                    this.setChanged();
                }
                this.extract += total;
                this.heat += total;
            }
        }
    }

    static <T extends BlockEntity> void transferAroundNonRodOnly(T self) {
        if (self.getLevel() == null) {
            return;
        }
        float totalToAverage = ((HeatBlockEntity)self).getHeat();
        int totalBlocks = 1;
        HeatBlockEntity[] setters = new HeatBlockEntity[6];
        for (int i = 0; i < 6; ++i) {
            Direction value = Direction.values()[i];
            BlockEntity entity = self.getLevel().getBlockEntity(self.getBlockPos().relative(value));
            if (!(entity instanceof HeatBlockEntity)) continue;
            HeatBlockEntity hbe = (HeatBlockEntity)entity;
            if (entity instanceof ReactorRodBlockEntity || !hbe.canAdd(value)) continue;
            setters[i] = hbe;
            totalToAverage += hbe.getHeat();
            ++totalBlocks;
        }
        HeatBlockEntity.average(self, totalToAverage, totalBlocks, setters);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        HeatBlockEntity.addToolTips(this, tooltip);
        CreateLang.translate((String)"tooltip.create_new_age.extracting", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
        CreateLang.translate((String)"tooltip.create_new_age.temperature", (Object[])new Object[]{StringFormatUtil.formatFloat(this.extract)}).style(ChatFormatting.AQUA).forGoggles(tooltip, 2);
        return true;
    }
}

