/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.block.portal;

import com.aetherteam.aether.attachment.AetherPlayerAttachment;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.client.sound.PortalTriggerSoundInstance;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.DeathScreen;
import net.minecraft.client.gui.screens.ReceivingLevelScreen;
import net.minecraft.client.gui.screens.WinScreen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Portal;

public class PortalClientUtil {
    public static void handleAetherPortal(Player player, AetherPlayerAttachment attachment) {
        if (player instanceof LocalPlayer) {
            LocalPlayer localPlayer = (LocalPlayer)player;
            if (!(Minecraft.getInstance().screen instanceof ReceivingLevelScreen)) {
                attachment.oPortalIntensity = attachment.portalIntensity;
                float f = 0.0f;
                if (localPlayer.portalProcess != null && localPlayer.portalProcess.isInsidePortalThisTick() && localPlayer.portalProcess.isSamePortal((Portal)AetherBlocks.AETHER_PORTAL.get())) {
                    if (!(Minecraft.getInstance().screen == null || Minecraft.getInstance().screen.isPauseScreen() || Minecraft.getInstance().screen instanceof DeathScreen || Minecraft.getInstance().screen instanceof WinScreen)) {
                        if (Minecraft.getInstance().screen instanceof AbstractContainerScreen) {
                            localPlayer.closeContainer();
                        }
                        Minecraft.getInstance().setScreen(null);
                    }
                    if (attachment.portalIntensity == 0.0f) {
                        PortalClientUtil.playTriggerSound();
                    }
                    f = 0.0125f;
                    localPlayer.portalProcess.setAsInsidePortalThisTick(false);
                } else if (attachment.portalIntensity > 0.0f) {
                    f = -0.05f;
                }
                attachment.portalIntensity = Mth.clamp((float)(attachment.portalIntensity + f), (float)0.0f, (float)1.0f);
            }
        }
    }

    public static void playTriggerSound() {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)PortalTriggerSoundInstance.forLocalAmbience((Player)Minecraft.getInstance().player, (SoundEvent)AetherSoundEvents.BLOCK_AETHER_PORTAL_TRIGGER.get(), Minecraft.getInstance().level.getRandom().nextFloat() * 0.4f + 0.8f, 0.25f));
    }

    public static void playTravelSound() {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forLocalAmbience((SoundEvent)((SoundEvent)AetherSoundEvents.BLOCK_AETHER_PORTAL_TRAVEL.get()), (float)(Minecraft.getInstance().level.getRandom().nextFloat() * 0.4f + 0.8f), (float)0.25f));
    }
}

