/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.renderer.entity;

import com.aetherteam.aether.entity.block.FloatingBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;

public class FloatingBlockRenderer
extends EntityRenderer<FloatingBlockEntity> {
    public FloatingBlockRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.shadowRadius = 0.5f;
    }

    public void render(FloatingBlockEntity floatingBlock, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLightIn) {
        Level world;
        BlockState blockState = floatingBlock.getBlockState();
        if (blockState.getRenderShape() == RenderShape.MODEL && blockState != (world = floatingBlock.level()).getBlockState(floatingBlock.blockPosition()) && blockState.getRenderShape() != RenderShape.INVISIBLE) {
            poseStack.pushPose();
            BlockPos blockPos = BlockPos.containing((double)floatingBlock.getX(), (double)floatingBlock.getBoundingBox().maxY, (double)floatingBlock.getZ());
            poseStack.translate(-0.5, 0.0, -0.5);
            BlockRenderDispatcher blockRenderDispatcher = Minecraft.getInstance().getBlockRenderer();
            BakedModel model = blockRenderDispatcher.getBlockModel(blockState);
            for (RenderType renderType : model.getRenderTypes(blockState, RandomSource.create((long)blockState.getSeed(floatingBlock.getStartPos())), ModelData.EMPTY)) {
                blockRenderDispatcher.getModelRenderer().tesselateBlock((BlockAndTintGetter)world, model, blockState, blockPos, poseStack, buffer.getBuffer(renderType), false, RandomSource.create(), blockState.getSeed(floatingBlock.getStartPos()), OverlayTexture.NO_OVERLAY, ModelData.EMPTY, renderType);
            }
            poseStack.popPose();
            super.render((Entity)floatingBlock, entityYaw, partialTicks, poseStack, buffer, packedLightIn);
        }
    }

    public ResourceLocation getTextureLocation(FloatingBlockEntity floatingBlock) {
        return InventoryMenu.BLOCK_ATLAS;
    }
}

