/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.event.listeners;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.event.hooks.DimensionHooks;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.event.entity.EntityTravelToDimensionEvent;
import net.neoforged.neoforge.event.entity.player.CanPlayerSleepEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.AlterGroundEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.level.SleepFinishedTimeEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class DimensionListener {
    public static void listen(IEventBus bus) {
        bus.addListener(DimensionListener::onPlayerLogin);
        bus.addListener(DimensionListener::onInteractWithPortalFrame);
        bus.addListener(DimensionListener::onWaterExistsInsidePortalFrame);
        bus.addListener(DimensionListener::onWorldTick);
        bus.addListener(DimensionListener::onEntityTravelToDimension);
        bus.addListener(DimensionListener::onPlayerChangedDimension);
        bus.addListener(DimensionListener::onPlayerTraveling);
        bus.addListener(DimensionListener::onWorldLoad);
        bus.addListener(DimensionListener::onSleepFinish);
        bus.addListener(DimensionListener::onTriedToSleep);
        bus.addListener(DimensionListener::onAlterGround);
    }

    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        DimensionHooks.startInAether(player);
    }

    public static void onInteractWithPortalFrame(PlayerInteractEvent.RightClickBlock event) {
        InteractionHand interactionHand;
        ItemStack itemStack;
        Direction direction;
        BlockPos blockPos;
        Level level;
        Player player = event.getEntity();
        if (DimensionHooks.createPortal(player, level = event.getLevel(), blockPos = event.getPos(), direction = event.getFace(), itemStack = event.getItemStack(), interactionHand = event.getHand())) {
            event.setCanceled(true);
        }
    }

    public static void onWaterExistsInsidePortalFrame(BlockEvent.NeighborNotifyEvent event) {
        FluidState fluidState;
        BlockState blockState;
        BlockPos blockPos;
        LevelAccessor level = event.getLevel();
        if (DimensionHooks.detectWaterInFrame(level, blockPos = event.getPos(), blockState = level.getBlockState(blockPos), fluidState = level.getFluidState(blockPos))) {
            event.setCanceled(true);
        }
    }

    public static void onWorldTick(LevelTickEvent.Post event) {
        Level level = event.getLevel();
        if (!level.isClientSide()) {
            DimensionHooks.tickTime(level);
            DimensionHooks.checkEternalDayConfig(level);
        }
    }

    public static void onEntityTravelToDimension(EntityTravelToDimensionEvent event) {
        Entity entity = event.getEntity();
        ResourceKey dimension = event.getDimension();
        DimensionHooks.dimensionTravel(entity, (ResourceKey<Level>)dimension);
        DimensionHooks.removePlayerAerbunny(entity);
    }

    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        DimensionHooks.remountPlayerAerbunny(player);
    }

    public static void onPlayerTraveling(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        DimensionHooks.travelling(player);
    }

    public static void onWorldLoad(LevelEvent.Load event) {
        LevelAccessor level = event.getLevel();
        DimensionHooks.initializeLevelData(level);
    }

    public static void onSleepFinish(SleepFinishedTimeEvent event) {
        LevelAccessor level = event.getLevel();
        Long time = DimensionHooks.finishSleep(level, event.getNewTime());
        if (time != null) {
            event.setTimeAddition(time.longValue());
        }
    }

    public static void onTriedToSleep(CanPlayerSleepEvent event) {
        ServerPlayer player = event.getEntity();
        if (DimensionHooks.isEternalDay((Player)player)) {
            event.setProblem(Player.BedSleepingProblem.NOT_POSSIBLE_NOW);
        }
    }

    public static void onAlterGround(AlterGroundEvent event) {
        TreeDecorator.Context context = event.getContext();
        AlterGroundEvent.StateProvider provider = event.getStateProvider();
        event.setStateProvider((rand, pos) -> {
            AtomicReference oldState = new AtomicReference();
            BlockState attemptedState = provider.getState(rand, pos);
            if (context.level().isStateAtPosition(pos, state -> {
                if (state.is(AetherTags.Blocks.AETHER_DIRT)) {
                    oldState.set(state);
                    return true;
                }
                return false;
            })) {
                return attemptedState.is(Blocks.PODZOL) ? (BlockState)oldState.get() : attemptedState;
            }
            return attemptedState;
        });
    }
}

