/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco;

import com.github.talrey.createdeco.CreateDecoMod;
import com.github.talrey.createdeco.blocks.DecalBlock;
import com.github.talrey.createdeco.blocks.ShippingContainerBlock;
import com.github.talrey.createdeco.blocks.SupportWedgeBlock;
import com.simibubi.create.content.decoration.palettes.ConnectedGlassPaneBlock;
import com.simibubi.create.content.decoration.palettes.ConnectedPillarBlock;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.RegistrateItemModelProvider;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import java.util.Locale;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;

public class BlockStateGenerator {
    public static void bar(String base, String post, ResourceLocation barTexture, ResourceLocation postTexture, DataGenContext<Block, ?> ctx, RegistrateBlockstateProvider prov) {
        MultiPartBlockStateBuilder builder = prov.getMultipartBuilder((Block)ctx.get());
        BlockModelBuilder sideModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(base + "_side", prov.mcLoc("block/iron_bars_side"))).texture("bars", barTexture)).texture("edge", postTexture)).texture("particle", postTexture);
        BlockModelBuilder sideAltModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(base + "_side_alt", prov.mcLoc("block/iron_bars_side_alt"))).texture("bars", barTexture)).texture("edge", postTexture)).texture("particle", postTexture);
        MultiPartBlockStateBuilder.PartBuilder model = (MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(base + "_post", prov.mcLoc("block/iron_bars_post"))).texture("bars", postTexture)).texture("particle", postTexture)).addModel();
        model.conditions.put((Object)BlockStateProperties.NORTH, (Object)false);
        model.conditions.put((Object)BlockStateProperties.SOUTH, (Object)false);
        model.conditions.put((Object)BlockStateProperties.EAST, (Object)false);
        model.conditions.put((Object)BlockStateProperties.WEST, (Object)false);
        builder.part().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(base + "_post_ends", prov.mcLoc("block/iron_bars_post_ends"))).texture("edge", postTexture)).texture("particle", postTexture)).addModel();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideModel).addModel()).conditions.put((Object)BlockStateProperties.NORTH, (Object)true);
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideModel).rotationY((int)90).addModel()).conditions.put((Object)BlockStateProperties.EAST, (Object)true);
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideAltModel).addModel()).conditions.put((Object)BlockStateProperties.SOUTH, (Object)true);
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideAltModel).rotationY((int)90).addModel()).conditions.put((Object)BlockStateProperties.WEST, (Object)true);
        if (!post.equals("")) {
            BlockModelBuilder sideOverlayModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(base + post, prov.mcLoc("block/iron_bars_side"))).texture("bars", prov.modLoc("block/palettes/metal_bars/" + base + post))).texture("edge", postTexture)).texture("particle", postTexture);
            BlockModelBuilder sideOverlayAltModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(base + post + "_alt", prov.mcLoc("block/iron_bars_side_alt"))).texture("bars", prov.modLoc("block/palettes/metal_bars/" + base + post))).texture("edge", postTexture)).texture("particle", postTexture);
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideOverlayModel).addModel()).conditions.put((Object)BlockStateProperties.NORTH, (Object)true);
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideOverlayModel).rotationY((int)90).addModel()).conditions.put((Object)BlockStateProperties.EAST, (Object)true);
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideOverlayAltModel).addModel()).conditions.put((Object)BlockStateProperties.SOUTH, (Object)true);
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideOverlayAltModel).rotationY((int)90).addModel()).conditions.put((Object)BlockStateProperties.WEST, (Object)true);
        }
    }

    public static void barItem(String base, String suf, ResourceLocation bartex, DataGenContext<Item, ?> ctx, RegistrateItemModelProvider prov) {
        if (suf.isEmpty()) {
            prov.singleTexture(base, prov.mcLoc("item/generated"), "layer0", bartex);
        } else {
            ((ItemModelBuilder)((ItemModelBuilder)prov.withExistingParent(base + suf, prov.mcLoc("item/generated"))).texture("layer0", bartex)).texture("layer1", prov.modLoc("block/palettes/metal_bars/" + base + suf));
        }
    }

    public static void fence(String metal, DataGenContext<Block, ?> ctx, RegistrateBlockstateProvider prov) {
        String regName = metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_");
        String postDir = "block/palettes/sheet_metal/";
        String meshDir = "block/palettes/chain_link_fence/";
        ResourceLocation post = prov.modLoc(postDir + regName + "_sheet_metal");
        ResourceLocation mesh = prov.modLoc(meshDir + regName + "_chain_link");
        char[][] states = new char[][]{{'f', 'f', 'f', 'f'}, {'t', 'x', 't', 'x'}, {'t', 'x', 'x', 't'}, {'x', 't', 't', 'x'}, {'x', 't', 'x', 't'}, {'t', 'f', 'f', 'f'}, {'f', 't', 'f', 'f'}, {'f', 'f', 't', 'f'}, {'f', 'f', 'f', 't'}};
        BlockModelBuilder center = (BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_post", prov.mcLoc("block/fence_post"))).texture("texture", post);
        BlockModelBuilder side = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_side", prov.modLoc("block/chainlink_fence_side"))).texture("particle", mesh)).texture("0", mesh);
        MultiPartBlockStateBuilder builder = prov.getMultipartBuilder((Block)ctx.get());
        for (char[] state : states) {
            MultiPartBlockStateBuilder.PartBuilder part = (MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)center).addModel();
            if (state[0] == 't') {
                part.conditions.put((Object)BlockStateProperties.NORTH, (Object)true);
            } else if (state[0] == 'f') {
                part.conditions.put((Object)BlockStateProperties.NORTH, (Object)false);
            }
            if (state[1] == 't') {
                part.conditions.put((Object)BlockStateProperties.SOUTH, (Object)true);
            } else if (state[1] == 'f') {
                part.conditions.put((Object)BlockStateProperties.SOUTH, (Object)false);
            }
            if (state[2] == 't') {
                part.conditions.put((Object)BlockStateProperties.EAST, (Object)true);
            } else if (state[2] == 'f') {
                part.conditions.put((Object)BlockStateProperties.EAST, (Object)false);
            }
            if (state[3] == 't') {
                part.conditions.put((Object)BlockStateProperties.WEST, (Object)true);
                continue;
            }
            if (state[3] != 'f') continue;
            part.conditions.put((Object)BlockStateProperties.WEST, (Object)false);
        }
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)center).addModel()).conditions.put((Object)BlockStateProperties.UP, (Object)true);
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)side).addModel()).conditions.put((Object)BlockStateProperties.EAST, (Object)true);
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)side).rotationY((int)90).addModel()).conditions.put((Object)BlockStateProperties.SOUTH, (Object)true);
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)side).rotationY((int)180).addModel()).conditions.put((Object)BlockStateProperties.WEST, (Object)true);
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)side).rotationY((int)270).addModel()).conditions.put((Object)BlockStateProperties.NORTH, (Object)true);
    }

    public static void cageLamp(ResourceLocation cage, ResourceLocation lampOn, ResourceLocation lampOff, DataGenContext<Block, ?> ctx, RegistrateBlockstateProvider prov) {
        prov.getVariantBuilder((Block)ctx.get()).forAllStates(state -> {
            int y = 0;
            int x = 90;
            switch ((Direction)state.getValue((Property)BlockStateProperties.FACING)) {
                case NORTH: {
                    y = 0;
                    break;
                }
                case SOUTH: {
                    y = 180;
                    break;
                }
                case WEST: {
                    y = -90;
                    break;
                }
                case EAST: {
                    y = 90;
                    break;
                }
                case DOWN: {
                    x = 180;
                    break;
                }
                default: {
                    x = 0;
                }
            }
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + ((Boolean)state.getValue((Property)BlockStateProperties.LIT) != false ? "" : "_off"), prov.modLoc("block/cage_lamp"))).texture("cage", cage)).texture("lamp", (Boolean)state.getValue((Property)BlockStateProperties.LIT) != false ? lampOn : lampOff)).texture("particle", cage)).rotationX(x).rotationY(y).build();
        });
    }

    public static void catwalk(CreateRegistrate reg, String metal, DataGenContext<Block, ?> ctx, RegistrateBlockstateProvider prov) {
        String name = metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_");
        ResourceLocation catwalkTexture = prov.modLoc("block/palettes/catwalks/" + name + "_catwalk");
        ResourceLocation supportTexture = prov.modLoc("block/palettes/support/" + name + "_support");
        BlockModelBuilder catwalk = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(name + "_catwalk", prov.modLoc("block/catwalk_top"))).texture("2", catwalkTexture)).texture("particle", catwalkTexture);
        BlockModelBuilder support = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(name + "_catwalk_support", prov.modLoc("block/catwalk_support"))).texture("0", supportTexture)).texture("particle", supportTexture);
        prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)catwalk).addModel();
        ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)((Block)ctx.get())).part().modelFile((ModelFile)support).addModel()).conditions.put((Object)BlockStateProperties.BOTTOM, (Object)true);
    }

    public static void catwalkItem(String metal, DataGenContext<Item, ?> ctx, RegistrateItemModelProvider prov) {
        ((ItemModelBuilder)prov.withExistingParent(ctx.getName(), prov.mcLoc("block/template_trapdoor_bottom"))).texture("texture", prov.modLoc("block/palettes/catwalks/" + metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_catwalk"));
    }

    public static void catwalkStair(String texture, DataGenContext<Block, ?> ctx, RegistrateBlockstateProvider prov) {
        ConfiguredModel.builder().modelFile((ModelFile)prov.models().getExistingFile(prov.modLoc(ctx.getName())));
    }

    public static void catwalkRailing(CreateRegistrate reg, String metal, DataGenContext<Block, ?> ctx, RegistrateBlockstateProvider prov) {
        String texture = reg.getModid() + ":block/palettes/catwalks/" + metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_catwalk";
        BlockModelBuilder rail_lower = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName(), prov.modLoc("block/catwalk_rail"))).texture("3", texture + "_rail")).texture("particle", texture + "_rail");
        ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)((Block)ctx.get())).part().modelFile((ModelFile)rail_lower).rotationY((int)90).addModel()).conditions.put((Object)BlockStateProperties.NORTH, (Object)true);
        ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)((Block)ctx.get())).part().modelFile((ModelFile)rail_lower).rotationY((int)-90).addModel()).conditions.put((Object)BlockStateProperties.SOUTH, (Object)true);
        ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)((Block)ctx.get())).part().modelFile((ModelFile)rail_lower).rotationY((int)180).addModel()).conditions.put((Object)BlockStateProperties.EAST, (Object)true);
        ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)((Block)ctx.get())).part().modelFile((ModelFile)rail_lower).rotationY((int)0).addModel()).conditions.put((Object)BlockStateProperties.WEST, (Object)true);
    }

    public static void catwalkRailingItem(CreateRegistrate reg, String metal, DataGenContext<Item, ?> ctx, RegistrateItemModelProvider prov) {
        prov.withExistingParent(ctx.getName(), prov.modLoc("block/" + ctx.getName()));
    }

    public static void door(CreateRegistrate reg, String metal, boolean locked, DataGenContext<Block, DoorBlock> ctx, RegistrateBlockstateProvider prov) {
        String regName = (locked ? "locked_" : "") + metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_");
        String path = "block/palettes/doors/" + regName;
        prov.doorBlock((DoorBlock)ctx.get(), prov.modLoc(path + "_door_bottom"), prov.modLoc(path + "_door_top"));
    }

    public static void doorItem(CreateRegistrate reg, String metal, DataGenContext<Item, ?> ctx, RegistrateItemModelProvider prov) {
        prov.singleTexture(ctx.getName(), prov.mcLoc("item/generated"), "layer0", prov.modLoc("item/" + ctx.getName()));
    }

    public static void hull(CreateRegistrate reg, String metal, DataGenContext<Block, ?> ctx, RegistrateBlockstateProvider prov) {
        String regName = ctx.getName();
        ResourceLocation front = prov.modLoc("block/palettes/hull/" + regName + "_front");
        ResourceLocation side = prov.modLoc("block/palettes/hull/" + regName + "_side");
        prov.getVariantBuilder((Block)ctx.get()).forAllStates(state -> {
            Direction dir = (Direction)state.getValue((Property)BlockStateProperties.FACING);
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName(), prov.modLoc("train_hull"))).texture("0", front)).texture("1", side)).texture("particle", front)).rotationX(dir == Direction.DOWN ? 270 : (dir.getAxis().isHorizontal() ? 0 : 90)).rotationY(dir.getAxis().isVertical() ? 0 : ((int)dir.toYRot() + 0) % 360).build();
        });
    }

    public static void support(CreateRegistrate reg, String metal, DataGenContext<Block, ?> ctx, RegistrateBlockstateProvider prov) {
        String regName = ctx.getName();
        ResourceLocation texture = prov.modLoc("block/palettes/support/" + regName);
        prov.directionalBlock((Block)ctx.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName(), prov.modLoc("support"))).texture("0", texture)).texture("particle", texture));
    }

    public static void supportWedge(CreateRegistrate reg, String metal, DataGenContext<Block, ?> ctx, RegistrateBlockstateProvider prov) {
        String regName = ctx.getName();
        ResourceLocation wedge = prov.modLoc("block/palettes/support_wedges/" + regName);
        prov.getVariantBuilder((Block)ctx.get()).forAllStates(state -> {
            int y = 0;
            int x = 0;
            Direction facing = (Direction)state.getValue((Property)SupportWedgeBlock.FACING);
            Integer orientation = (Integer)state.getValue((Property)SupportWedgeBlock.ORIENTATION);
            boolean horizontal = false;
            block0 : switch (facing) {
                case NORTH: {
                    switch (orientation) {
                        case 1: {
                            x = 0;
                            y = 0;
                            break;
                        }
                        case 2: {
                            x = 0;
                            y = 270;
                            horizontal = true;
                            break;
                        }
                        case 3: {
                            x = 270;
                            y = 0;
                            break;
                        }
                        case 4: {
                            x = 0;
                            y = 0;
                            horizontal = true;
                        }
                    }
                    break;
                }
                case SOUTH: {
                    switch (orientation) {
                        case 1: {
                            x = 0;
                            y = 180;
                            break;
                        }
                        case 2: {
                            x = 0;
                            y = 180;
                            horizontal = true;
                            break;
                        }
                        case 3: {
                            x = 270;
                            y = 180;
                            break;
                        }
                        case 4: {
                            x = 0;
                            y = 90;
                            horizontal = true;
                        }
                    }
                    break;
                }
                case EAST: {
                    switch (orientation) {
                        case 1: {
                            x = 0;
                            y = 90;
                            break;
                        }
                        case 2: {
                            x = 0;
                            y = 0;
                            horizontal = true;
                            break;
                        }
                        case 3: {
                            x = 270;
                            y = 90;
                            break;
                        }
                        case 4: {
                            x = 0;
                            y = 90;
                            horizontal = true;
                        }
                    }
                    break;
                }
                case WEST: {
                    switch (orientation) {
                        case 1: {
                            x = 0;
                            y = 270;
                            break block0;
                        }
                        case 2: {
                            x = 0;
                            y = 270;
                            horizontal = true;
                            break block0;
                        }
                        case 3: {
                            x = 270;
                            y = 270;
                            break block0;
                        }
                        case 4: {
                            x = 0;
                            y = 180;
                            horizontal = true;
                        }
                    }
                }
            }
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + (horizontal ? "_horizontal" : ""), prov.modLoc("block/support_wedge" + (horizontal ? "_horizontal" : "")))).texture("0", wedge)).texture("particle", wedge)).rotationX(x).rotationY(y).build();
        });
    }

    public static void trapdoorItem(CreateRegistrate reg, String metal, DataGenContext<Item, ?> ctx, RegistrateItemModelProvider prov) {
        String regName = metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_");
        ((ItemModelBuilder)prov.withExistingParent(ctx.getName(), prov.mcLoc("block/template_trapdoor_bottom"))).texture("texture", prov.modLoc("block/palettes/doors/" + regName + "_trapdoor"));
    }

    public static void placard(CreateRegistrate reg, DyeColor color, DataGenContext<Block, ?> ctx, RegistrateBlockstateProvider prov) {
        String regName = color.name().toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_placard";
        prov.horizontalFaceBlock((Block)ctx.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(regName, prov.modLoc("block/dyed_placard"))).texture("0", prov.modLoc("block/palettes/placard/" + regName))).texture("particle", prov.modLoc("block/palettes/placard/" + regName)));
    }

    public static void shippingContainer(CreateRegistrate reg, DyeColor color, DataGenContext<Block, ?> ctx, RegistrateBlockstateProvider prov) {
        prov.getVariantBuilder((Block)ctx.getEntry()).forAllStates(state -> {
            String regName = color.name().toLowerCase(Locale.ROOT).replaceAll(" ", "_");
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(regName + "_shipping_container", prov.modLoc("block/shipping_container"))).texture("0", prov.modLoc("block/palettes/shipping_containers/" + regName + "/vault_bottom_small"))).texture("1", prov.modLoc("block/palettes/shipping_containers/" + regName + "/vault_front_small"))).texture("2", prov.modLoc("block/palettes/shipping_containers/" + regName + "/vault_side_small"))).texture("3", prov.modLoc("block/palettes/shipping_containers/" + regName + "/vault_top_small"))).texture("particle", prov.modLoc("block/palettes/shipping_containers/" + regName + "/vault_top_small"))).rotationY(state.getValue(ShippingContainerBlock.HORIZONTAL_AXIS) == Direction.Axis.X ? 90 : 0).build();
        });
    }

    public static void coinstackBlock(ResourceLocation side, ResourceLocation bottom, ResourceLocation top, DataGenContext<Block, ?> ctx, RegistrateBlockstateProvider prov) {
        prov.getVariantBuilder((Block)ctx.getEntry()).forAllStates(state -> {
            int layer = (Integer)state.getValue((Property)BlockStateProperties.LAYERS);
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_" + layer, prov.modLoc("block/layers_bottom_top_" + layer))).texture("side", side)).texture("bottom", bottom)).texture("top", top)).build();
        });
    }

    public static void brick(DataGenContext<Block, ?> ctx, RegistrateBlockstateProvider prov, String color) {
        prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().cubeAll(ctx.getName(), prov.modLoc("block/palettes/bricks/" + color + "/" + ctx.getName())));
    }

    public static void brickStair(DataGenContext<Block, StairBlock> ctx, RegistrateBlockstateProvider prov, String color) {
        prov.stairsBlock((StairBlock)ctx.get(), prov.modLoc("block/palettes/bricks/" + color + "/" + ctx.getName().replaceAll("_stair", "")));
    }

    public static void brickSlab(DataGenContext<Block, SlabBlock> ctx, RegistrateBlockstateProvider prov, String color) {
        String block = ctx.getName().replaceAll("_slab", "s");
        ResourceLocation blockModel = prov.modLoc("block/" + block);
        ResourceLocation texture = prov.modLoc("block/palettes/bricks/" + color + "/" + block);
        prov.slabBlock((SlabBlock)ctx.get(), blockModel, texture);
    }

    public static void brickWall(DataGenContext<Block, WallBlock> ctx, RegistrateBlockstateProvider prov, String color) {
        String block = ctx.getName().replaceAll("_wall", "s");
        ResourceLocation texture = prov.modLoc("block/palettes/bricks/" + color + "/" + block);
        prov.wallBlock((WallBlock)ctx.get(), block, texture);
    }

    public static void window(DataGenContext<Block, ?> ctx, RegistrateBlockstateProvider prov, NonNullFunction<String, ResourceLocation> sideTexture, NonNullFunction<String, ResourceLocation> endTexture) {
        prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().cubeColumn(ctx.getName(), (ResourceLocation)sideTexture.apply((Object)ctx.getName()), (ResourceLocation)endTexture.apply((Object)ctx.getName())));
    }

    public static NonNullBiConsumer<DataGenContext<Block, ConnectedGlassPaneBlock>, RegistrateBlockstateProvider> windowPane(String CGPparents, String prefix, ResourceLocation sideTexture, ResourceLocation topTexture) {
        Function<RegistrateBlockstateProvider, ModelFile> post = BlockStateGenerator.getPaneModelProvider(CGPparents, prefix, "post", sideTexture, topTexture);
        Function<RegistrateBlockstateProvider, ModelFile> side = BlockStateGenerator.getPaneModelProvider(CGPparents, prefix, "side", sideTexture, topTexture);
        Function<RegistrateBlockstateProvider, ModelFile> sideAlt = BlockStateGenerator.getPaneModelProvider(CGPparents, prefix, "side_alt", sideTexture, topTexture);
        Function<RegistrateBlockstateProvider, ModelFile> noSide = BlockStateGenerator.getPaneModelProvider(CGPparents, prefix, "noside", sideTexture, topTexture);
        Function<RegistrateBlockstateProvider, ModelFile> noSideAlt = BlockStateGenerator.getPaneModelProvider(CGPparents, prefix, "noside_alt", sideTexture, topTexture);
        return (c, p) -> p.paneBlock((IronBarsBlock)c.get(), (ModelFile)post.apply((RegistrateBlockstateProvider)p), (ModelFile)side.apply((RegistrateBlockstateProvider)p), (ModelFile)sideAlt.apply((RegistrateBlockstateProvider)p), (ModelFile)noSide.apply((RegistrateBlockstateProvider)p), (ModelFile)noSideAlt.apply((RegistrateBlockstateProvider)p));
    }

    private static Function<RegistrateBlockstateProvider, ModelFile> getPaneModelProvider(String CGPparents, String prefix, String partial, ResourceLocation sideTexture, ResourceLocation topTexture) {
        return p -> ((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent(prefix + partial, CreateDecoMod.id(CGPparents + partial))).texture("pane", sideTexture)).texture("edge", topTexture);
    }

    public static void ladder(DataGenContext<Block, ?> ctx, RegistrateBlockstateProvider prov, String regName) {
        prov.horizontalBlock((Block)ctx.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName(), prov.modLoc("block/ladder"))).texture("0", prov.modLoc("block/palettes/ladders/ladder_" + regName + "_hoop"))).texture("1", prov.modLoc("block/palettes/ladders/ladder_" + regName))).texture("particle", prov.modLoc("block/palettes/ladders/ladder_" + regName)));
    }

    public static void facade(CreateRegistrate reg, String metal, DataGenContext<Block, ?> ctx, RegistrateBlockstateProvider prov) {
        String name = metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_");
        ResourceLocation catwalkTexture = prov.modLoc("block/palettes/catwalks/" + name + "_catwalk");
        BlockModelBuilder facade = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(name + "_facade", prov.modLoc("block/facade"))).texture("2", catwalkTexture)).texture("particle", catwalkTexture);
        ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)((Block)ctx.get())).part().modelFile((ModelFile)facade).rotationY((int)0).addModel()).conditions.put((Object)BlockStateProperties.NORTH, (Object)true);
        ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)((Block)ctx.get())).part().modelFile((ModelFile)facade).rotationY((int)180).addModel()).conditions.put((Object)BlockStateProperties.SOUTH, (Object)true);
        ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)((Block)ctx.get())).part().modelFile((ModelFile)facade).rotationY((int)90).addModel()).conditions.put((Object)BlockStateProperties.EAST, (Object)true);
        ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)((Block)ctx.get())).part().modelFile((ModelFile)facade).rotationY((int)-90).addModel()).conditions.put((Object)BlockStateProperties.WEST, (Object)true);
        ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)((Block)ctx.get())).part().modelFile((ModelFile)facade).rotationX((int)-90).addModel()).conditions.put((Object)BlockStateProperties.UP, (Object)true);
        ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)((Block)ctx.get())).part().modelFile((ModelFile)facade).rotationX((int)90).addModel()).conditions.put((Object)BlockStateProperties.DOWN, (Object)true);
    }

    public static void decal(CreateRegistrate reg, String prefix, DataGenContext<Block, DecalBlock> ctx, RegistrateBlockstateProvider prov) {
        String texture = reg.getModid() + ":block/palettes/decals/decal_" + prefix;
        prov.getVariantBuilder((Block)ctx.get()).forAllStates(state -> {
            int y = 69;
            int x = 69;
            Direction direction = (Direction)state.getValue((Property)DecalBlock.FACING);
            block0 : switch ((AttachFace)state.getValue((Property)DecalBlock.FACE)) {
                case FLOOR: {
                    switch (direction) {
                        case EAST: {
                            y = 90;
                            x = 90;
                            break;
                        }
                        case WEST: {
                            y = 270;
                            x = 90;
                            break;
                        }
                        case SOUTH: {
                            y = 180;
                            x = 90;
                            break;
                        }
                        case NORTH: {
                            y = 0;
                            x = 90;
                            break;
                        }
                        case UP: 
                        case DOWN: {
                            y = 0;
                            x = 0;
                        }
                    }
                    break;
                }
                case WALL: {
                    switch (direction) {
                        case EAST: {
                            y = 270;
                            x = 0;
                            break;
                        }
                        case WEST: {
                            y = 90;
                            x = 0;
                            break;
                        }
                        case SOUTH: {
                            y = 0;
                            x = 0;
                            break;
                        }
                        case NORTH: 
                        case UP: 
                        case DOWN: {
                            y = 180;
                            x = 0;
                        }
                    }
                    break;
                }
                case CEILING: {
                    switch (direction) {
                        case EAST: {
                            y = 90;
                            x = 270;
                            break block0;
                        }
                        case WEST: {
                            y = 270;
                            x = 270;
                            break block0;
                        }
                        case SOUTH: {
                            y = 180;
                            x = 270;
                            break block0;
                        }
                        case NORTH: {
                            y = 0;
                            x = 270;
                            break block0;
                        }
                        case UP: 
                        case DOWN: {
                            y = 0;
                            x = 0;
                        }
                    }
                }
            }
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName(), prov.modLoc("block/decal"))).texture("0", reg.getModid() + ":block/palettes/decals/decal_back")).texture("1", texture)).texture("particle", texture)).rotationX(x).rotationY(y).build();
        });
    }

    public static void brickWallItem(DataGenContext<Item, BlockItem> ctx, RegistrateItemModelProvider prov, String color) {
        String block = ctx.getName().replaceAll("_wall", "s");
        ResourceLocation texture = prov.modLoc("block/palettes/bricks/" + color + "/" + block);
        prov.wallInventory(ctx.getName(), texture);
    }

    public static void sheetMetal(String metal, DataGenContext<Block, ConnectedPillarBlock> ctx, RegistrateBlockstateProvider prov) {
        String name = metal.toLowerCase().replace(" ", "_") + "_sheet_metal";
        ResourceLocation side = CreateDecoMod.id("block/palettes/sheet_metal/" + name);
        ResourceLocation end = CreateDecoMod.id("block/palettes/sheet_metal/" + name + "_top");
        prov.getVariantBuilder((Block)ctx.getEntry()).forAllStatesExcept(state -> {
            Direction.Axis axis = (Direction.Axis)state.getValue((Property)BlockStateProperties.AXIS);
            if (axis == Direction.Axis.Y) {
                return ConfiguredModel.builder().modelFile((ModelFile)prov.models().cubeColumn(ctx.getName(), side, end)).uvLock(false).build();
            }
            return ConfiguredModel.builder().modelFile((ModelFile)prov.models().cubeColumnHorizontal(ctx.getName() + "_horizontal", side, end)).uvLock(false).rotationX(90).rotationY(axis == Direction.Axis.X ? 90 : 0).build();
        }, new Property[]{BlockStateProperties.WATERLOGGED, ConnectedPillarBlock.NORTH, ConnectedPillarBlock.SOUTH, ConnectedPillarBlock.EAST, ConnectedPillarBlock.WEST});
    }
}

