/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco.api;

import com.github.talrey.createdeco.BlockStateGenerator;
import com.github.talrey.createdeco.api.CreateDecoTags;
import com.simibubi.create.AllTags;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.SoundType;

public class Bars {
    public static BlockBuilder<IronBarsBlock, ?> build(CreateRegistrate reg, String metal, String suffix, boolean doPost) {
        ResourceLocation postTexture;
        ResourceLocation barTexture;
        String base = metal.replace(' ', '_').toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_bars";
        String suf = suffix.equals("") ? "" : "_" + suffix.replace(' ', '_').toLowerCase(Locale.ROOT);
        String post = "block/palettes/metal_bars/" + base + (doPost ? "_post" : "");
        if (metal.equals("Iron")) {
            postTexture = barTexture = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"block/iron_bars");
        } else {
            barTexture = ResourceLocation.fromNamespaceAndPath((String)reg.getModid(), (String)("block/palettes/metal_bars/" + base));
            postTexture = ResourceLocation.fromNamespaceAndPath((String)reg.getModid(), (String)post);
        }
        ResourceLocation bartex = barTexture;
        ResourceLocation postex = postTexture;
        BlockBuilder block = (BlockBuilder)reg.block(base + suf, IronBarsBlock::new).properties(props -> props.noOcclusion().strength(5.0f, 6.0f).requiresCorrectToolForDrops().sound(SoundType.NETHERITE_BLOCK)).blockstate((ctx, prov) -> BlockStateGenerator.bar(base, suf, bartex, postex, ctx, prov)).addLayer(() -> RenderType::cutoutMipped).tag(new TagKey[]{BlockTags.MINEABLE_WITH_PICKAXE}).item().model((ctx, prov) -> BlockStateGenerator.barItem(base, suf, bartex, ctx, prov)).properties(p -> metal.equals("Netherite") ? p.fireResistant() : p).build();
        if (!suffix.equals("overlay")) {
            block = block.tag(new TagKey[]{AllTags.AllBlockTags.FAN_TRANSPARENT.tag});
        }
        return block;
    }

    public static <T extends Block> void recipeStonecutting(Supplier<Item> ingot, DataGenContext<Block, T> ctx, RegistrateRecipeProvider prov) {
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ingot.get()}), (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get()), (int)4).unlockedBy("has_item", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)ingot.get()}).build()})).save((RecipeOutput)prov, ctx.getName() + "_from_stonecutting");
    }

    public static <T extends Block> void recipeCrafting(Supplier<Item> ingot, DataGenContext<Block, T> ctx, RegistrateRecipeProvider prov) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get()), (int)16).pattern("bbb").pattern("bbb").define(Character.valueOf('b'), (ItemLike)ingot.get()).unlockedBy("has_item", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ingot.get()})).save((RecipeOutput)prov, ctx.getName());
    }

    public static <T extends Block> void recipeCraftingPanels(String metal, DataGenContext<Block, T> ctx, RegistrateRecipeProvider prov) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get()), (int)16).pattern("ppp").pattern("ppp").define(Character.valueOf('p'), CreateDecoTags.plate(metal)).unlockedBy("has_item", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(CreateDecoTags.plate(metal)).build()})).save((RecipeOutput)prov, ctx.getName());
    }
}

