/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco.blocks;

import com.mojang.serialization.MapCodec;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import com.simibubi.create.foundation.placement.PoleHelper;
import java.util.function.Predicate;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.createmod.catnip.placement.PlacementOffset;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SupportBlock
extends DirectionalBlock
implements ProperWaterloggedBlock {
    private static final VoxelShape NORTH = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    private static final VoxelShape SOUTH = Block.box((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST = Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST = Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape UP = Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape DOWN = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    private static final VoxelShape X = Shapes.join((VoxelShape)EAST, (VoxelShape)WEST, (BooleanOp)BooleanOp.OR);
    private static final VoxelShape Y = Shapes.join((VoxelShape)UP, (VoxelShape)DOWN, (BooleanOp)BooleanOp.OR);
    private static final VoxelShape Z = Shapes.join((VoxelShape)NORTH, (VoxelShape)SOUTH, (BooleanOp)BooleanOp.OR);
    private static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());

    public SupportBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends DirectionalBlock> codec() {
        return null;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.WATERLOGGED, FACING});
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        ItemStack heldItem = player.getItemInHand(hand);
        IPlacementHelper placementHelper = PlacementHelpers.get((int)placementHelperId);
        if (!placementHelper.matchesItem(heldItem)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        return placementHelper.getOffset(player, world, state, pos, ray).placeInWorld(world, (BlockItem)heldItem.getItem(), player, hand, ray);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        FluidState fluid = ctx.getLevel().getFluidState(ctx.getClickedPos());
        BlockState result = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getClickedFace())).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(fluid.is((Fluid)Fluids.WATER)));
        return result;
    }

    public boolean canPlaceLiquid(@Nullable Player playerEntity, BlockGetter world, BlockPos pos, BlockState state, Fluid fluid) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) == false && fluid == Fluids.WATER;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : Fluids.EMPTY.defaultFluidState();
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext ctx) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext ctx) {
        return switch (((Direction)state.getValue((Property)FACING)).getAxis()) {
            case Direction.Axis.X -> Shapes.join((VoxelShape)Y, (VoxelShape)Z, (BooleanOp)BooleanOp.OR);
            case Direction.Axis.Z -> Shapes.join((VoxelShape)X, (VoxelShape)Y, (BooleanOp)BooleanOp.OR);
            default -> Shapes.join((VoxelShape)X, (VoxelShape)Z, (BooleanOp)BooleanOp.OR);
        };
    }

    public static boolean isSupportBlock(ItemStack test) {
        return test.getItem() instanceof BlockItem && SupportBlock.isSupportBlock(((BlockItem)test.getItem()).getBlock());
    }

    public static boolean isSupportBlock(Block test) {
        return test instanceof SupportBlock;
    }

    @MethodsReturnNonnullByDefault
    private static class PlacementHelper
    extends PoleHelper<Direction> {
        public PlacementHelper() {
            super(state -> SupportBlock.isSupportBlock(state.getBlock()), state -> ((Direction)state.getValue((Property)FACING)).getAxis(), (Property)FACING);
        }

        public Predicate<ItemStack> getItemPredicate() {
            return SupportBlock::isSupportBlock;
        }

        public Predicate<BlockState> getStatePredicate() {
            return state -> SupportBlock.isSupportBlock(state.getBlock());
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            PlacementOffset offset = super.getOffset(player, world, state, pos, ray);
            offset.withTransform(offset.getTransform());
            return offset;
        }
    }
}

