/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco.items;

import com.github.talrey.createdeco.BlockRegistry;
import com.github.talrey.createdeco.LoaderUtil;
import com.github.talrey.createdeco.blocks.ShippingContainerBlock;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.content.logistics.vault.ItemVaultItem;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.ApiStatus;

public class ShippingContainerBlockItem
extends ItemVaultItem {
    @ApiStatus.Internal
    public static boolean IS_PLACING_NBT = false;

    public ShippingContainerBlockItem(Block block, Item.Properties props) {
        super(block, props);
    }

    public InteractionResult place(BlockPlaceContext ctx) {
        IS_PLACING_NBT = LoaderUtil.checkPlacingNbt(ctx);
        InteractionResult initialResult = super.place(ctx);
        IS_PLACING_NBT = false;
        if (!initialResult.consumesAction()) {
            return initialResult;
        }
        this.tryMultiPlace(ctx);
        return initialResult;
    }

    private void tryMultiPlace(BlockPlaceContext ctx) {
        BlockState other;
        BlockPos offset;
        int zOffset;
        int xOffset;
        BlockPos start;
        BlockPos pos;
        BlockPos placedOn;
        Player player = ctx.getPlayer();
        if (player == null || player.isSteppingCarefully()) {
            return;
        }
        ShippingContainerBlock myBlock = (ShippingContainerBlock)this.getBlock();
        Direction face = ctx.getClickedFace();
        ItemStack stack = ctx.getItemInHand();
        Level level = ctx.getLevel();
        BlockState placedOnState = level.getBlockState(placedOn = (pos = ctx.getClickedPos()).relative(face.getOpposite()));
        if (!myBlock.isSameType(placedOnState)) {
            return;
        }
        ShippingContainerBlock.Entity beAt = (ShippingContainerBlock.Entity)ConnectivityHandler.partAt((BlockEntityType)((BlockEntityType)BlockRegistry.CONTAINER_ENTITIES.get(myBlock.COLOR).get()), (BlockGetter)level, (BlockPos)placedOn);
        if (beAt == null) {
            return;
        }
        ShippingContainerBlock.Entity controller = beAt.getControllerBE();
        if (controller == null) {
            return;
        }
        int width = controller.getWidth();
        if (width == 1) {
            return;
        }
        int blocksToPlace = 0;
        Direction.Axis axis = ShippingContainerBlock.getVaultBlockAxis(placedOnState);
        if (axis == null || axis != face.getAxis()) {
            return;
        }
        Direction facing = Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        BlockPos blockPos = start = face == facing.getOpposite() ? controller.getBlockPos().relative(facing.getOpposite()) : controller.getBlockPos().relative(facing, controller.getHeight());
        if (VecHelper.getCoordinate((Vec3i)start, (Direction.Axis)axis) != VecHelper.getCoordinate((Vec3i)pos, (Direction.Axis)axis)) {
            return;
        }
        for (xOffset = 0; xOffset < width; ++xOffset) {
            for (zOffset = 0; zOffset < width; ++zOffset) {
                offset = axis == Direction.Axis.X ? start.offset(0, xOffset, zOffset) : start.offset(xOffset, zOffset, 0);
                other = level.getBlockState(offset);
                if (ShippingContainerBlock.isVault(other)) continue;
                if (!other.canBeReplaced()) {
                    return;
                }
                ++blocksToPlace;
            }
        }
        if (!player.isCreative() && stack.getCount() < blocksToPlace) {
            return;
        }
        for (xOffset = 0; xOffset < width; ++xOffset) {
            for (zOffset = 0; zOffset < width; ++zOffset) {
                offset = axis == Direction.Axis.X ? start.offset(0, xOffset, zOffset) : start.offset(xOffset, zOffset, 0);
                other = level.getBlockState(offset);
                if (myBlock.isSameType(other)) continue;
                BlockPlaceContext context = BlockPlaceContext.at((BlockPlaceContext)ctx, (BlockPos)offset, (Direction)face);
                IS_PLACING_NBT = LoaderUtil.checkPlacingNbt(context);
                super.place(context);
                IS_PLACING_NBT = false;
            }
        }
    }
}

