/*
 * Decompiled with CFR 0.152.
 */
package net.player005.vegandelightfabric;

import net.minecraft.core.Holder;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.gameevent.GameEvent;
import net.player005.vegandelightfabric.VeganDelightMod;
import net.player005.vegandelightfabric.VeganItems;

public class RatsCompat {
    static void initialize() {
        if (RatsCompat.isRatsModInstalled()) {
            RatsCompat.registerSoymilkCheeseCauldron();
        }
    }

    public static boolean isRatsModInstalled() {
        return VeganDelightMod.getPlatform().isModLoaded("rats");
    }

    static void registerSoymilkCheeseCauldron() {
        CauldronInteraction.EMPTY.map().put((Item)VeganItems.SOYMILK_BUCKET.value(), (state, level, pos, player, hand, stack) -> {
            if (!level.isClientSide()) {
                player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
                player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.BUCKET)));
                player.awardStat(Stats.USE_CAULDRON);
                level.setBlockAndUpdate(pos, RatsCompat.getRatsMilkCauldron().defaultBlockState());
                level.playSound(null, pos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.gameEvent(null, (Holder)GameEvent.FLUID_PLACE, pos);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        });
    }

    public static Block getRatsMilkCauldron() {
        return (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.tryParse((String)"rats:cauldron_milk"));
    }
}

