/*
 * Decompiled with CFR 0.152.
 */
package net.player005.vegandelightfabric;

import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.player005.vegandelightfabric.VeganDelightMod;
import net.player005.vegandelightfabric.VeganItems;
import net.player005.vegandelightfabric.fluids.VeganFluids;
import vectorwing.farmersdelight.common.block.WildCropBlock;

public class VeganBlocks {
    public static final Holder<Block> SOYBEAN_CROP = VeganBlocks.register(() -> new CropBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHEAT)){

        protected ItemLike getBaseSeedId() {
            return (ItemLike)VeganItems.SOYBEAN.value();
        }
    }, "soybean_crop", false);
    public static final Holder<Block> WILD_SOYBEAN = VeganBlocks.register(() -> new WildCropBlock(MobEffects.DAMAGE_BOOST, 12, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ALLIUM)), "wild_soybean", true);
    public static final Holder<Block> POTTED_WILD_SOYBEAN = VeganBlocks.register(() -> new FlowerPotBlock((Block)WILD_SOYBEAN.value(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POTTED_ALLIUM)), "potted_wild_soybean", false);
    public static final Holder<Block> SOYBEAN_BAG = VeganBlocks.register(() -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_WOOL)), "soybean_bag", true);
    public static final Holder<LiquidBlock> SOYMILK = VeganBlocks.register(() -> new LiquidBlock(VeganFluids.SOYMILK.get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WATER)){}, "soymilk", false);
    public static final Holder<LiquidBlock> APPLESAUCE = VeganBlocks.register(() -> new LiquidBlock(VeganFluids.APPLESAUCE.get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WATER)){}, "applesauce_fluid", false);

    public static <T extends Block> Holder<T> register(Supplier<T> block, String name, boolean registerItem) {
        ResourceLocation id = ResourceLocation.tryBuild((String)VeganDelightMod.modID, (String)name);
        assert (id != null);
        Holder holder = VeganDelightMod.getPlatform().register(BuiltInRegistries.BLOCK, id, block);
        if (registerItem) {
            VeganDelightMod.getPlatform().register(BuiltInRegistries.ITEM, id, () -> new BlockItem((Block)holder.value(), new Item.Properties()));
        }
        return holder;
    }

    public static Block[] getAllBlockItems() {
        return new Block[]{(Block)SOYBEAN_BAG.value(), (Block)WILD_SOYBEAN.value()};
    }

    static void initialize() {
    }
}

