/*
 * Decompiled with CFR 0.152.
 */
package net.player005.vegandelightfabric;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.player005.recipe_modification.api.RecipeModification;
import net.player005.vegandelightfabric.RatsCompat;
import net.player005.vegandelightfabric.VeganBlocks;
import net.player005.vegandelightfabric.VeganCreativeTab;
import net.player005.vegandelightfabric.VeganDelightPlatform;
import net.player005.vegandelightfabric.VeganItems;
import net.player005.vegandelightfabric.fluids.VeganFluids;
import net.player005.vegandelightfabric.labels.VeganDataComponents;
import net.player005.vegandelightfabric.labels.VeganLabels;

public class VeganDelightMod {
    public static String modID = "vegandelight";
    private static VeganDelightPlatform platform;

    public static void initializeAll(VeganDelightPlatform platform) {
        VeganDelightMod.platform = platform;
        VeganFluids.initialize();
        VeganItems.initialize();
        VeganBlocks.initialize();
        VeganCreativeTab.initialize();
        VeganDataComponents.initialize();
        RecipeModification.onRecipeInit(recipeManager -> VeganLabels.initialize());
        RatsCompat.initialize();
        VeganDelightMod.registerBiomeModifiers();
        VeganDelightMod.registerTrades();
        platform.registerCompostables();
    }

    private static void registerBiomeModifiers() {
        VeganDelightMod.getPlatform().registerBiomeModifier(0.4f, 0.9f, VeganDelightMod.getPlatform().overworldBiomeTag(), VeganDelightMod.getPlatform().undergroundBiomeTag(), GenerationStep.Decoration.VEGETAL_DECORATION, (ResourceKey<PlacedFeature>)ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.parse((String)"vegandelight:patch_wild_soybean")));
    }

    private static void registerTrades() {
        VeganDelightMod.getPlatform().registerVillagerTrade(VillagerProfession.FARMER, 1, (trader, random) -> new MerchantOffer(new ItemCost((ItemLike)VeganItems.SOYBEAN.value(), random.nextIntBetweenInclusive(16, 24)), new ItemStack((ItemLike)Items.EMERALD, 1), 12, 5, 0.05f));
        VeganDelightMod.getPlatform().registerVillagerTrade(VillagerProfession.LEATHERWORKER, 4, (trader, random) -> new MerchantOffer(new ItemCost((ItemLike)VeganItems.LEATHER_SUBSTITUTE.value(), random.nextIntBetweenInclusive(8, 16)), new ItemStack((ItemLike)Items.EMERALD, 1), 12, 15, 0.1f));
    }

    public static VeganDelightPlatform getPlatform() {
        return platform;
    }
}

