/*
 * Decompiled with CFR 0.152.
 */
package net.player005.vegandelightfabric.labels;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableCollection;
import com.mojang.datafixers.util.Unit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.player005.recipe_modification.api.RecipeModification;
import net.player005.vegandelightfabric.labels.VeganDataComponents;
import net.player005.vegandelightfabric.labels.VeganTags;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.LoggerFactory;

public class VeganLabels {
    private static final Map<Item, VeganStatus> veganFromRecipes = new HashMap<Item, VeganStatus>();
    private static boolean debugMode = false;

    @ApiStatus.Internal
    public static void initialize() {
        RecipeModification.registerGlobalResultModifier((recipe, result, recipeInput) -> {
            if (recipeInput != null) {
                VeganLabels.modifyRecipeResult(recipeInput, result);
            }
            return result;
        });
        Stopwatch timer = Stopwatch.createStarted();
        ArrayList<Item> traversedList = new ArrayList<Item>(BuiltInRegistries.ITEM.size());
        for (Item item : BuiltInRegistries.ITEM) {
            if (traversedList.contains(item)) continue;
            VeganLabels.scanRecipesRecursively(item, traversedList);
        }
        LoggerFactory.getLogger(VeganLabels.class).info("Scanned {} items for vegan recipes in {}", (Object)BuiltInRegistries.ITEM.size(), (Object)timer);
    }

    public static VeganStatus isVegan(ItemStack itemStack) {
        Boolean fromComponent = (Boolean)itemStack.get((DataComponentType)VeganDataComponents.is_vegan.value());
        if (fromComponent != null) {
            return VeganStatus.fromBoolean(fromComponent);
        }
        if (itemStack.is(VeganTags.VEGAN)) {
            return VeganStatus.VEGAN;
        }
        if (itemStack.is(VeganTags.NOT_VEGAN)) {
            return VeganStatus.NOT_VEGAN;
        }
        return veganFromRecipes.getOrDefault(itemStack.getItem(), VeganStatus.UNKNOWN);
    }

    public static void setIsVegan(ItemStack stack, boolean isVegan) {
        boolean isFood;
        boolean bl = isFood = stack.is(VeganTags.SHOULD_HAVE_DATA_COMPONENTS_ADDED) || stack.getUseAnimation() == UseAnim.EAT || stack.getUseAnimation() == UseAnim.DRINK;
        if (!isFood && !stack.has((DataComponentType)VeganDataComponents.contains_substitutes.value())) {
            return;
        }
        VeganStatus currentStatus = VeganLabels.isVegan(stack);
        if (stack.has((DataComponentType)VeganDataComponents.is_vegan.value())) {
            return;
        }
        if (isVegan && (currentStatus == VeganStatus.VEGAN || currentStatus == VeganStatus.UNKNOWN)) {
            return;
        }
        if (!isVegan && currentStatus == VeganStatus.NOT_VEGAN) {
            return;
        }
        stack.set((DataComponentType)VeganDataComponents.is_vegan.value(), (Object)isVegan);
    }

    private static void scanRecipesRecursively(Item item, List<Item> alreadyTraversed) {
        alreadyTraversed.add(item);
        ImmutableCollection recipes = RecipeModification.getRecipesByResult((Item)item);
        int veganRecipes = 0;
        int nonVeganRecipes = 0;
        for (RecipeHolder recipeHolder : recipes) {
            if (VeganLabels.recipeNotVegan(alreadyTraversed, recipeHolder.value())) {
                ++nonVeganRecipes;
                continue;
            }
            ++veganRecipes;
        }
        VeganStatus result = VeganStatus.UNKNOWN;
        if (veganRecipes > nonVeganRecipes) {
            result = VeganStatus.VEGAN;
        }
        if (veganRecipes < nonVeganRecipes) {
            result = VeganStatus.NOT_VEGAN;
        }
        int differencePercentage = (int)(100.0f * (float)Math.abs(veganRecipes - nonVeganRecipes) / (float)recipes.size());
        if (recipes.size() > 1 && differencePercentage < 20) {
            result = VeganStatus.UNKNOWN;
        }
        veganFromRecipes.put(item, result);
    }

    private static boolean recipeNotVegan(List<Item> alreadyTraversed, Recipe<?> recipe) {
        for (Ingredient ingredient : recipe.getIngredients()) {
            int nonVeganItems = 0;
            int total = 0;
            for (ItemStack itemStack : ingredient.getItems()) {
                if (itemStack.is(VeganTags.VEGAN_ALTERNATIVE)) continue;
                VeganStatus vegan = VeganLabels.isVegan(itemStack);
                if (vegan == VeganStatus.UNKNOWN) {
                    Item unknownItem = itemStack.getItem();
                    if (!alreadyTraversed.contains(unknownItem)) {
                        VeganLabels.scanRecipesRecursively(unknownItem, alreadyTraversed);
                    }
                    vegan = veganFromRecipes.getOrDefault(unknownItem, VeganStatus.UNKNOWN);
                }
                if (vegan == VeganStatus.NOT_VEGAN) {
                    ++nonVeganItems;
                }
                ++total;
            }
            if (!((float)nonVeganItems / (float)total >= 0.5f)) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldRenderTooltip(ItemStack itemStack) {
        return !Boolean.FALSE.equals(itemStack.get((DataComponentType)VeganDataComponents.is_vegan.value())) && !itemStack.is(VeganTags.VEGAN_ALTERNATIVE) && itemStack.getComponents().has((DataComponentType)VeganDataComponents.contains_substitutes.value());
    }

    public static void addTooltipLines(ItemStack stack, List<Component> tooltip) {
        if (Boolean.FALSE.equals(stack.get((DataComponentType)VeganDataComponents.is_vegan.value()))) {
            tooltip.add(1, (Component)Component.literal((String)"Not vegan").setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY).withItalic(Boolean.valueOf(true))));
        }
        if (debugMode) {
            tooltip.add(1, (Component)Component.literal((String)("Result: " + VeganLabels.isVegan(stack).name())));
            tooltip.add(1, (Component)Component.literal((String)("Default from recipes: " + String.valueOf((Object)veganFromRecipes.get(stack.getItem())))));
            tooltip.add(1, (Component)Component.literal((String)("Component: " + String.valueOf(stack.get((DataComponentType)VeganDataComponents.is_vegan.value())))));
        }
        if (!VeganLabels.shouldRenderTooltip(stack)) {
            return;
        }
        tooltip.add(1, (Component)Component.literal((String)"Vegan").setStyle(Style.EMPTY.withColor(35908).withItalic(Boolean.valueOf(true)).withBold(Boolean.valueOf(true))));
    }

    private static void modifyRecipeResult(RecipeInput recipeInput, ItemStack result) {
        boolean vegan = true;
        for (int i = 0; i < recipeInput.size(); ++i) {
            ItemStack item = recipeInput.getItem(i);
            if (VeganLabels.isVegan(item) == VeganStatus.NOT_VEGAN) {
                vegan = false;
            }
            if (!item.is(VeganTags.VEGAN_ALTERNATIVE) && !item.has((DataComponentType)VeganDataComponents.contains_substitutes.value())) continue;
            result.set((DataComponentType)VeganDataComponents.contains_substitutes.value(), (Object)Unit.INSTANCE);
        }
        VeganLabels.setIsVegan(result, vegan);
    }

    public static enum VeganStatus {
        VEGAN,
        NOT_VEGAN,
        UNKNOWN;


        static VeganStatus fromBoolean(@Nullable Boolean b) {
            if (b == null) {
                return UNKNOWN;
            }
            return b != false ? VEGAN : NOT_VEGAN;
        }
    }
}

