/*
 * Decompiled with CFR 0.152.
 */
package com.christofmeg.justenoughbreeding.config.integrated;

import com.christofmeg.justenoughbreeding.jei.recipe.TemperRecipe;
import com.christofmeg.justenoughbreeding.utils.CommonUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NaturalistIntegration {
    static final String MOD = "naturalist";
    static final List<String> animalNames = new ArrayList<String>();
    static final List<String> tamableOnly = new ArrayList<String>();
    static final Map<String, String> ingredients = new HashMap<String, String>();
    static final Map<String, String> extraIngredients = new HashMap<String, String>();
    static final Map<String, Boolean> needsToBeTamed = new HashMap<String, Boolean>();
    static final Map<String, String> resultEggs = new HashMap<String, String>();
    static final Map<String, Integer> eggsAmountMin = new HashMap<String, Integer>();
    static final Map<String, Integer> eggsAmountMax = new HashMap<String, Integer>();
    static final Map<String, Integer> breedingCooldown = new HashMap<String, Integer>();
    static final Map<String, String> tamingIngredients = new HashMap<String, String>();
    static final Map<String, Integer> tamingChance = new HashMap<String, Integer>();
    static final Map<String, List<TemperRecipe>> temperDataMap = new HashMap<String, List<TemperRecipe>>();

    public static void init() {
        CommonUtils.addAnimalEggLaying("alligator", "#naturalist:alligator_food_items", "naturalist:alligator_egg", 4, animalNames, ingredients, breedingCooldown, resultEggs, eggsAmountMin, eggsAmountMax);
        CommonUtils.addAnimal("bear", "#naturalist:bear_tempt_items", animalNames, ingredients, breedingCooldown);
        CommonUtils.addAnimal("boar", "#naturalist:boar_food_items", animalNames, ingredients, breedingCooldown);
        CommonUtils.addAnimal("butterfly", "#minecraft:flowers", animalNames, ingredients, breedingCooldown);
        CommonUtils.addAnimal("deer", "minecraft:apple", animalNames, ingredients, breedingCooldown);
        CommonUtils.addAnimal("duck", "#naturalist:duck_food_items", animalNames, ingredients, breedingCooldown);
        CommonUtils.addAnimal("giraffe", "minecraft:hay_block", animalNames, ingredients, breedingCooldown);
        CommonUtils.addAnimal("hippo", "minecraft:melon", "minecraft:water_bucket", animalNames, ingredients, extraIngredients, breedingCooldown);
        CommonUtils.addAnimalEggLaying("snail", "minecraft:beetroot", "naturalist:snail_eggs", 1, animalNames, ingredients, breedingCooldown, resultEggs, eggsAmountMin, eggsAmountMax);
        CommonUtils.addAnimalEggLayingWithTamedTag("tortoise", "#naturalist:tortoise_tempt_items", "naturalist:tortoise_egg", 4, animalNames, ingredients, breedingCooldown, resultEggs, eggsAmountMin, eggsAmountMax, needsToBeTamed);
        CommonUtils.addAnimalWithTamedTag("zebra", "minecraft:golden_apple, minecraft:enchanted_golden_apple, minecraft:golden_carrot", animalNames, ingredients, breedingCooldown, needsToBeTamed);
        CommonUtils.addAnimalNames(animalNames, ingredients, extraIngredients, MOD, breedingCooldown, needsToBeTamed, resultEggs, eggsAmountMin, eggsAmountMax);
        CommonUtils.addTamableOnly("bluejay", "#naturalist:bird_food_items", tamableOnly, tamingIngredients, tamingChance);
        CommonUtils.addTamableOnly("canary", "#naturalist:bird_food_items", tamableOnly, tamingIngredients, tamingChance);
        CommonUtils.addTamableOnly("cardinal", "#naturalist:bird_food_items", tamableOnly, tamingIngredients, tamingChance);
        CommonUtils.addTamableOnly("finch", "#naturalist:bird_food_items", tamableOnly, tamingIngredients, tamingChance);
        CommonUtils.addTamableOnly("robin", "#naturalist:bird_food_items", tamableOnly, tamingIngredients, tamingChance);
        CommonUtils.addTamableOnly("sparrow", "#naturalist:bird_food_items", tamableOnly, tamingIngredients, tamingChance);
        CommonUtils.addTamableOnly("lizard", "#naturalist:lizard_tempt_items", tamableOnly, tamingIngredients, tamingChance);
        CommonUtils.addTamableOnly("tortoise", "#naturalist:tortoise_tempt_items", tamableOnly, tamingIngredients, tamingChance);
        CommonUtils.addTamableAnimalNames(tamableOnly, tamingIngredients, tamingChance, MOD);
        CommonUtils.addTemperAnimal("zebra", new String[]{"minecraft:sugar", "minecraft:wheat", "minecraft:apple", "minecraft:golden_carrot", "minecraft:golden_apple", "minecraft:enchanted_golden_apple"}, new int[]{3, 3, 3, 5, 10, 10}, temperDataMap);
        CommonUtils.addAnimalTempers(temperDataMap, MOD);
    }
}

