/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.base.data.recipe;

import com.simibubi.create.api.data.recipe.BaseRecipeProvider;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import dev.ithundxr.createnumismatics.Numismatics;
import dev.ithundxr.createnumismatics.base.data.recipe.DyedRecipeList;
import dev.ithundxr.createnumismatics.base.data.recipe.Ingredients;
import dev.ithundxr.createnumismatics.registry.NumismaticsBlocks;
import dev.ithundxr.createnumismatics.registry.NumismaticsItems;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.createmod.catnip.registry.RegisteredObjectsHelper;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCookingSerializer;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.ItemLike;

public class NumismaticsStandardRecipeGen
extends BaseRecipeProvider {
    BaseRecipeProvider.GeneratedRecipe ANDESITE_DEPOSITOR = this.create((ItemProviderEntry<? extends ItemLike, ?>)NumismaticsBlocks.ANDESITE_DEPOSITOR).unlockedBy(Ingredients::andesiteCasing).viaShapeless(b -> b.requires(Ingredients.andesiteCasing()).requires(Ingredients.ironSheet()));
    BaseRecipeProvider.GeneratedRecipe BRASS_DEPOSITOR = this.create((ItemProviderEntry<? extends ItemLike, ?>)NumismaticsBlocks.BRASS_DEPOSITOR).unlockedBy(Ingredients::brassCasing).viaShapeless(b -> b.requires(Ingredients.brassCasing()).requires(Ingredients.sturdySheet()).requires(Ingredients.electronTube()));
    BaseRecipeProvider.GeneratedRecipe BANK_TERMINAL = this.create((ItemProviderEntry<? extends ItemLike, ?>)NumismaticsBlocks.BANK_TERMINAL).unlockedBy(Ingredients::precisionMechanism).viaShapeless(b -> b.requires(Ingredients.precisionMechanism()).requires(Ingredients.industrialIron()).requires(Ingredients.electronTube()));
    BaseRecipeProvider.GeneratedRecipe BANKING_GUIDE = this.create((ItemProviderEntry<? extends ItemLike, ?>)NumismaticsItems.BANKING_GUIDE).unlockedBy(Ingredients::cogCoin).viaShapeless(b -> b.requires(Ingredients.cogCoin()).requires(Ingredients.sturdySheet()).requires(Ingredients.paper()));
    BaseRecipeProvider.GeneratedRecipe VENDOR = this.create((ItemProviderEntry<? extends ItemLike, ?>)NumismaticsBlocks.VENDOR).unlockedBy(Ingredients::brassCasing).viaShaped(b -> b.pattern("o").pattern("#").pattern("I").define(Character.valueOf('o'), Ingredients.framedGlass()).define(Character.valueOf('#'), Ingredients.brassCasing()).define(Character.valueOf('I'), Ingredients.electronTube()));
    DyedRecipeList CARDS = new DyedRecipeList(color -> this.create((ItemProviderEntry<? extends ItemLike, ?>)NumismaticsItems.CARDS.get((DyeColor)color)).unlockedBy(Ingredients::precisionMechanism).viaShaped(b -> b.pattern("@_/").define(Character.valueOf('@'), Ingredients.precisionMechanism()).define(Character.valueOf('_'), Ingredients.ironSheet()).define(Character.valueOf('/'), Ingredients.dye(color))));
    DyedRecipeList ID_CARDS = new DyedRecipeList(color -> this.create((ItemProviderEntry<? extends ItemLike, ?>)NumismaticsItems.ID_CARDS.get((DyeColor)color)).unlockedBy(Ingredients::precisionMechanism).viaShaped(b -> b.pattern(" / ").pattern("_-,").define(Character.valueOf(','), Ingredients.brassNugget()).define(Character.valueOf('-'), Ingredients.paper()).define(Character.valueOf('_'), Ingredients.ironSheet()).define(Character.valueOf('/'), Ingredients.dye(color))));

    GeneratedRecipeBuilder create(Supplier<ItemLike> result) {
        return new GeneratedRecipeBuilder("/", result);
    }

    GeneratedRecipeBuilder create(ResourceLocation result) {
        return new GeneratedRecipeBuilder("/", result);
    }

    GeneratedRecipeBuilder create(ItemProviderEntry<? extends ItemLike, ?> result) {
        return this.create(() -> result.get());
    }

    public NumismaticsStandardRecipeGen(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, "numismatics");
    }

    public String getName() {
        return "Numismatics Standard Recipes";
    }

    class GeneratedRecipeBuilder {
        private final String path;
        private String suffix;
        private Supplier<? extends ItemLike> result;
        private ResourceLocation compatDatagenOutput;
        private Supplier<ItemPredicate> unlockedBy;
        private int amount;

        private GeneratedRecipeBuilder(String path) {
            this.path = path;
            this.suffix = "";
            this.amount = 1;
        }

        public GeneratedRecipeBuilder(String path, Supplier<? extends ItemLike> result) {
            this(path);
            this.result = result;
        }

        public GeneratedRecipeBuilder(String path, ResourceLocation result) {
            this(path);
            this.compatDatagenOutput = result;
        }

        GeneratedRecipeBuilder returns(int amount) {
            this.amount = amount;
            return this;
        }

        GeneratedRecipeBuilder unlockedBy(Supplier<? extends ItemLike> item) {
            this.unlockedBy = () -> ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)item.get()}).build();
            return this;
        }

        GeneratedRecipeBuilder unlockedByTag(Supplier<TagKey<Item>> tag) {
            this.unlockedBy = () -> ItemPredicate.Builder.item().of((TagKey)tag.get()).build();
            return this;
        }

        GeneratedRecipeBuilder withSuffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        BaseRecipeProvider.GeneratedRecipe viaShaped(UnaryOperator<ShapedRecipeBuilder> builder) {
            return NumismaticsStandardRecipeGen.this.register(consumer -> {
                ShapedRecipeBuilder b = (ShapedRecipeBuilder)builder.apply(ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)this.result.get(), (int)this.amount));
                if (this.unlockedBy != null) {
                    b.unlockedBy("has_item", RecipeProvider.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{this.unlockedBy.get()}));
                }
                b.save(consumer, this.createLocation("crafting"));
            });
        }

        BaseRecipeProvider.GeneratedRecipe viaShapeless(UnaryOperator<ShapelessRecipeBuilder> builder) {
            return NumismaticsStandardRecipeGen.this.register(consumer -> {
                ShapelessRecipeBuilder b = (ShapelessRecipeBuilder)builder.apply(ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)this.result.get(), (int)this.amount));
                if (this.unlockedBy != null) {
                    b.unlockedBy("has_item", RecipeProvider.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{this.unlockedBy.get()}));
                }
                b.save(consumer, this.createLocation("crafting"));
            });
        }

        private ResourceLocation createSimpleLocation(String recipeType) {
            return Numismatics.asResource(recipeType + "/" + this.getRegistryName().getPath() + this.suffix);
        }

        private ResourceLocation createLocation(String recipeType) {
            return Numismatics.asResource(recipeType + "/" + this.path + "/" + this.getRegistryName().getPath() + this.suffix);
        }

        private ResourceLocation getRegistryName() {
            return this.compatDatagenOutput == null ? RegisteredObjectsHelper.getKeyOrThrow((Item)this.result.get().asItem()) : this.compatDatagenOutput;
        }

        GeneratedCookingRecipeBuilder viaCooking(Supplier<? extends ItemLike> item) {
            return this.unlockedBy(item).viaCookingIngredient(() -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)item.get()}));
        }

        GeneratedCookingRecipeBuilder viaCookingTag(Supplier<TagKey<Item>> tag) {
            return this.unlockedByTag(tag).viaCookingIngredient(() -> Ingredient.of((TagKey)((TagKey)tag.get())));
        }

        GeneratedCookingRecipeBuilder viaCookingIngredient(Supplier<Ingredient> ingredient) {
            return new GeneratedCookingRecipeBuilder(ingredient);
        }

        class GeneratedCookingRecipeBuilder {
            private final Supplier<Ingredient> ingredient;
            private float exp;
            private int cookingTime;
            private final SimpleCookingSerializer<?> FURNACE = (SimpleCookingSerializer)RecipeSerializer.SMELTING_RECIPE;
            private final SimpleCookingSerializer<?> SMOKER = (SimpleCookingSerializer)RecipeSerializer.SMOKING_RECIPE;
            private final SimpleCookingSerializer<?> BLAST = (SimpleCookingSerializer)RecipeSerializer.BLASTING_RECIPE;
            private final SimpleCookingSerializer<?> CAMPFIRE = (SimpleCookingSerializer)RecipeSerializer.CAMPFIRE_COOKING_RECIPE;

            GeneratedCookingRecipeBuilder(Supplier<Ingredient> ingredient) {
                this.ingredient = ingredient;
                this.cookingTime = 200;
                this.exp = 0.0f;
            }

            GeneratedCookingRecipeBuilder forDuration(int duration) {
                this.cookingTime = duration;
                return this;
            }

            GeneratedCookingRecipeBuilder rewardXP(float xp) {
                this.exp = xp;
                return this;
            }

            BaseRecipeProvider.GeneratedRecipe inFurnace() {
                return this.inFurnace(b -> b);
            }

            BaseRecipeProvider.GeneratedRecipe inFurnace(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
                return this.create(RecipeSerializer.SMELTING_RECIPE, builder, SmeltingRecipe::new, 1.0f);
            }

            BaseRecipeProvider.GeneratedRecipe inSmoker() {
                return this.inSmoker(b -> b);
            }

            BaseRecipeProvider.GeneratedRecipe inSmoker(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
                this.create(RecipeSerializer.SMELTING_RECIPE, builder, SmeltingRecipe::new, 1.0f);
                this.create(RecipeSerializer.CAMPFIRE_COOKING_RECIPE, builder, CampfireCookingRecipe::new, 3.0f);
                return this.create(RecipeSerializer.SMOKING_RECIPE, builder, SmokingRecipe::new, 0.5f);
            }

            BaseRecipeProvider.GeneratedRecipe inBlastFurnace() {
                return this.inBlastFurnace(b -> b);
            }

            BaseRecipeProvider.GeneratedRecipe inBlastFurnace(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
                this.create(RecipeSerializer.SMELTING_RECIPE, builder, SmeltingRecipe::new, 1.0f);
                return this.create(RecipeSerializer.BLASTING_RECIPE, builder, BlastingRecipe::new, 0.5f);
            }

            private <T extends AbstractCookingRecipe> BaseRecipeProvider.GeneratedRecipe create(RecipeSerializer<T> serializer, UnaryOperator<SimpleCookingRecipeBuilder> builder, AbstractCookingRecipe.Factory<T> factory, float cookingTimeModifier) {
                return NumismaticsStandardRecipeGen.this.register(consumer -> {
                    boolean isOtherMod = GeneratedRecipeBuilder.this.compatDatagenOutput != null;
                    SimpleCookingRecipeBuilder b = (SimpleCookingRecipeBuilder)builder.apply(SimpleCookingRecipeBuilder.generic((Ingredient)this.ingredient.get(), (RecipeCategory)RecipeCategory.MISC, (ItemLike)(isOtherMod ? Items.DIRT : GeneratedRecipeBuilder.this.result.get()), (float)this.exp, (int)((int)((float)this.cookingTime * cookingTimeModifier)), (RecipeSerializer)serializer, (AbstractCookingRecipe.Factory)factory));
                    if (GeneratedRecipeBuilder.this.unlockedBy != null) {
                        b.unlockedBy("has_item", RecipeProvider.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{GeneratedRecipeBuilder.this.unlockedBy.get()}));
                    }
                    b.save(consumer, GeneratedRecipeBuilder.this.createSimpleLocation(RegisteredObjectsHelper.getKeyOrThrow((RecipeSerializer)serializer).getPath()));
                });
            }
        }
    }
}

