/*
 * Decompiled with CFR 0.152.
 */
package net.zjjohn121110.aethersdelight;

import com.mojang.logging.LogUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.zjjohn121110.aethersdelight.Config;
import net.zjjohn121110.aethersdelight.block.entity.AethersDelightBlockEntity;
import net.zjjohn121110.aethersdelight.loot.AethersDelightLootModifier;
import net.zjjohn121110.aethersdelight.registry.AethersDelightBlocks;
import net.zjjohn121110.aethersdelight.registry.AethersDelightItems;
import org.slf4j.Logger;

@Mod(value="aethersdelight")
public class AethersDelight {
    public static final String MODID = "aethersdelight";
    private static final Logger LOGGER = LogUtils.getLogger();

    public AethersDelight(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        AethersDelightItems.register(modEventBus);
        AethersDelightBlocks.register(modEventBus);
        AethersDelightBlockEntity.TILES.register(modEventBus);
        AethersDelightLootModifier.LOOT_MODIFIERS.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM COMMON SETUP");
        if (Config.logDirtBlock) {
            LOGGER.info("DIRT BLOCK >> {}", (Object)BuiltInRegistries.BLOCK.getKey((Object)Blocks.DIRT));
        }
        LOGGER.info(Config.magicNumberIntroduction + Config.magicNumber);
        Config.items.forEach(item -> LOGGER.info("ITEM >> {}", (Object)item.toString()));
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    @EventBusSubscriber(modid="aethersdelight", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("HELLO FROM CLIENT SETUP");
            LOGGER.info("MINECRAFT NAME >> {}", (Object)Minecraft.getInstance().getUser().getName());
        }
    }
}

