/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client.compat;

import eu.midnightdust.lib.util.PlatformFunctions;
import eu.midnightdust.midnightcontrols.MidnightControls;
import eu.midnightdust.midnightcontrols.client.MidnightControlsClient;
import eu.midnightdust.midnightcontrols.client.compat.BedrockifyCompat;
import eu.midnightdust.midnightcontrols.client.compat.CompatHandler;
import eu.midnightdust.midnightcontrols.client.compat.EMICompat;
import eu.midnightdust.midnightcontrols.client.compat.HQMCompat;
import eu.midnightdust.midnightcontrols.client.compat.InventoryTabsCompat;
import eu.midnightdust.midnightcontrols.client.compat.SodiumCompat;
import eu.midnightdust.midnightcontrols.client.compat.YACLCompat;
import eu.midnightdust.midnightcontrols.client.controller.InputManager;
import eu.midnightdust.midnightcontrols.client.util.storage.AxisStorage;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.phys.BlockHitResult;
import org.aperlambda.lambdacommon.utils.LambdaReflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MidnightControlsCompat {
    @Deprecated
    public static final List<CompatHandler> HANDLERS = new ArrayList<CompatHandler>();

    public static void init() {
        if (PlatformFunctions.isModLoaded((String)"emi")) {
            MidnightControls.log("Adding EMI compatibility...");
            MidnightControlsCompat.registerCompatHandler(new EMICompat());
        }
        if (PlatformFunctions.isModLoaded((String)"hardcorequesting") && LambdaReflection.doesClassExist("hardcorequesting.client.interfaces.GuiBase")) {
            MidnightControls.log("Adding HQM compatibility...");
            MidnightControlsCompat.registerCompatHandler(new HQMCompat());
        }
        if (PlatformFunctions.isModLoaded((String)"bedrockify")) {
            MidnightControls.log("Adding Bedrockify compatibility...");
            MidnightControlsCompat.registerCompatHandler(new BedrockifyCompat());
        }
        if (PlatformFunctions.isModLoaded((String)"yet-another-config-lib")) {
            MidnightControls.log("Adding YACL compatibility...");
            MidnightControlsCompat.registerCompatHandler(new YACLCompat());
        }
        if (PlatformFunctions.isModLoaded((String)"sodium")) {
            MidnightControls.log("Adding Sodium compatibility...");
            MidnightControlsCompat.registerCompatHandler(new SodiumCompat());
        }
        if (PlatformFunctions.isModLoaded((String)"inventorytabs")) {
            MidnightControls.log("Adding Inventory Tabs compatibility...");
            MidnightControlsCompat.registerCompatHandler(new InventoryTabsCompat());
        }
        HANDLERS.forEach(CompatHandler::handle);
        InputManager.loadButtonBindings();
    }

    public static void registerCompatHandler(@NotNull CompatHandler handler) {
        HANDLERS.add(handler);
    }

    public static Stream<CompatHandler> streamCompatHandlers() {
        return HANDLERS.stream();
    }

    public static boolean requireMouseOnScreen(Screen screen) {
        return MidnightControlsCompat.streamCompatHandlers().anyMatch(handler -> handler.requireMouseOnScreen(screen));
    }

    public static boolean handleTabs(Screen screen, boolean forward) {
        return MidnightControlsCompat.streamCompatHandlers().anyMatch(handler -> handler.handleTabs(screen, forward));
    }

    public static boolean handlePages(Screen screen, boolean forward) {
        return MidnightControlsCompat.streamCompatHandlers().anyMatch(handler -> handler.handlePages(screen, forward));
    }

    @Nullable
    public static CompatHandler.SlotPos getSlotAt(@NotNull Screen screen, int mouseX, int mouseY) {
        for (CompatHandler handler : HANDLERS) {
            CompatHandler.SlotPos slot = handler.getSlotAt(screen, mouseX, mouseY);
            if (slot == null) continue;
            return slot;
        }
        return null;
    }

    public static String getAttackActionAt(@NotNull Minecraft client, @Nullable BlockHitResult placeResult) {
        for (CompatHandler handler : HANDLERS) {
            String action = handler.getAttackActionAt(client, placeResult);
            if (action == null) continue;
            return action;
        }
        return null;
    }

    public static String getUseActionAt(@NotNull Minecraft client, @Nullable BlockHitResult placeResult) {
        for (CompatHandler handler : HANDLERS) {
            String action = handler.getUseActionAt(client, placeResult);
            if (action == null) continue;
            return action;
        }
        return null;
    }

    public static boolean handleMenuBack(@NotNull Minecraft client, @NotNull Screen screen) {
        for (CompatHandler handler : HANDLERS) {
            if (!handler.handleMenuBack(client, screen)) continue;
            return true;
        }
        return false;
    }

    public static void handleCamera(double targetYaw, double targetPitch) {
        HANDLERS.forEach(handler -> handler.handleCamera(MidnightControlsClient.client, targetYaw, targetPitch));
    }

    public static void handleMovement(AxisStorage storage, float adjustedValue) {
        MidnightControlsCompat.streamCompatHandlers().forEach(handler -> handler.handleMovement(MidnightControlsClient.client, storage, adjustedValue));
    }
}

