/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client.controller;

import com.google.common.base.Predicates;
import eu.midnightdust.midnightcontrols.client.MidnightControlsClient;
import eu.midnightdust.midnightcontrols.client.controller.ButtonCategory;
import eu.midnightdust.midnightcontrols.client.controller.InputHandlers;
import eu.midnightdust.midnightcontrols.client.controller.InputManager;
import eu.midnightdust.midnightcontrols.client.controller.MovementHandler;
import eu.midnightdust.midnightcontrols.client.controller.PressAction;
import eu.midnightdust.midnightcontrols.client.enums.ButtonState;
import eu.midnightdust.midnightcontrols.client.gui.RingScreen;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.aperlambda.lambdacommon.Identifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ButtonBinding {
    public static final ButtonCategory MOVEMENT_CATEGORY;
    public static final ButtonCategory GAMEPLAY_CATEGORY;
    public static final ButtonCategory INVENTORY_CATEGORY;
    public static final ButtonCategory MULTIPLAYER_CATEGORY;
    public static final ButtonCategory MISC_CATEGORY;
    public static final ButtonBinding ATTACK;
    public static final ButtonBinding BACK;
    public static final ButtonBinding CHAT;
    public static final ButtonBinding CONTROLS_RING;
    public static final ButtonBinding DROP_ITEM;
    public static final ButtonBinding FORWARD;
    public static final ButtonBinding HOTBAR_LEFT;
    public static final ButtonBinding HOTBAR_RIGHT;
    public static final ButtonBinding INVENTORY;
    public static final ButtonBinding EXIT;
    public static final ButtonBinding JUMP;
    public static final ButtonBinding LEFT;
    public static final ButtonBinding PAUSE_GAME;
    public static final ButtonBinding PICK_BLOCK;
    public static final ButtonBinding PLAYER_LIST;
    public static final ButtonBinding RIGHT;
    public static final ButtonBinding SCREENSHOT;
    public static final ButtonBinding DEBUG_SCREEN;
    public static final ButtonBinding SLOT_DOWN;
    public static final ButtonBinding SLOT_LEFT;
    public static final ButtonBinding SLOT_RIGHT;
    public static final ButtonBinding SLOT_UP;
    public static final ButtonBinding SNEAK;
    public static final ButtonBinding SPRINT;
    public static final ButtonBinding SWAP_HANDS;
    public static final ButtonBinding TAB_LEFT;
    public static final ButtonBinding TAB_RIGHT;
    public static final ButtonBinding PAGE_LEFT;
    public static final ButtonBinding PAGE_RIGHT;
    public static final ButtonBinding TAKE;
    public static final ButtonBinding TAKE_ALL;
    public static final ButtonBinding QUICK_MOVE;
    public static final ButtonBinding TOGGLE_PERSPECTIVE;
    public static final ButtonBinding USE;
    private int[] button;
    private final int[] defaultButton;
    private final String key;
    private final Component text;
    private KeyMapping mcKeyBinding = null;
    protected Predicate<ButtonBinding> filter;
    private final List<PressAction> actions = new ArrayList<PressAction>(Collections.singletonList(PressAction.DEFAULT_ACTION));
    private final boolean hasCooldown;
    private int cooldownLength = 5;
    private int cooldown = 0;
    private boolean pressed = false;

    public ButtonBinding(String key, int[] defaultButton, List<PressAction> actions, Predicate<ButtonBinding> filter, boolean hasCooldown) {
        this.defaultButton = defaultButton;
        this.setButton(defaultButton);
        this.key = key;
        this.text = Component.translatable((String)this.key);
        this.filter = filter;
        this.actions.addAll(actions);
        this.hasCooldown = hasCooldown;
    }

    public ButtonBinding(String key, int[] defaultButton, List<PressAction> actions, Predicate<ButtonBinding> filter, boolean hasCooldown, int cooldownLength) {
        this.defaultButton = defaultButton;
        this.setButton(defaultButton);
        this.key = key;
        this.text = Component.translatable((String)this.key);
        this.filter = filter;
        this.actions.addAll(actions);
        this.hasCooldown = hasCooldown;
        this.cooldownLength = cooldownLength;
    }

    public ButtonBinding(String key, int[] defaultButton, boolean hasCooldown) {
        this(key, defaultButton, Collections.emptyList(), (Predicate<ButtonBinding>)Predicates.alwaysTrue(), hasCooldown);
    }

    public ButtonBinding(String key, int[] defaultButton, boolean hasCooldown, int cooldownLength) {
        this(key, defaultButton, Collections.emptyList(), (Predicate<ButtonBinding>)Predicates.alwaysTrue(), hasCooldown, cooldownLength);
    }

    public int[] getButton() {
        return this.button;
    }

    public void setButton(int[] button) {
        this.button = button;
        if (InputManager.hasBinding(this)) {
            InputManager.sortBindings();
        }
    }

    public void setPressed(boolean pressed) {
        this.pressed = pressed;
    }

    public boolean isButton(int[] button) {
        return InputManager.areButtonsEquivalent(button, this.button);
    }

    @Deprecated
    public boolean isButtonDown() {
        return this.isPressed();
    }

    public boolean isPressed() {
        return this.pressed;
    }

    public boolean isNotBound() {
        return this.button.length == 0 || this.button[0] == -1;
    }

    public int[] getDefaultButton() {
        return this.defaultButton;
    }

    public boolean isDefault() {
        return this.button.length == this.defaultButton.length && InputManager.areButtonsEquivalent(this.button, this.defaultButton);
    }

    public String getButtonCode() {
        return Arrays.stream(this.button).mapToObj(btn -> Integer.valueOf(btn).toString()).collect(Collectors.joining("+"));
    }

    public void setKeyBinding(@Nullable KeyMapping keyBinding) {
        this.mcKeyBinding = keyBinding;
    }

    public boolean isAvailable() {
        return this.filter.test(this);
    }

    public void update() {
        if (this.hasCooldown && this.cooldown > 0) {
            --this.cooldown;
        }
    }

    public void handle(@NotNull Minecraft client, float value, @NotNull ButtonState state) {
        if (state == ButtonState.REPEAT && this.hasCooldown && this.cooldown != 0) {
            return;
        }
        if (this.hasCooldown && state.isPressed()) {
            this.cooldown = this.cooldownLength;
        }
        for (int i = this.actions.size() - 1; i >= 0 && !this.actions.get(i).press(client, this, value, state); --i) {
        }
    }

    @NotNull
    public String getName() {
        return this.key;
    }

    @NotNull
    public String getTranslationKey() {
        return I18n.exists((String)("midnightcontrols.action." + this.getName())) ? "midnightcontrols.action." + this.getName() : this.getName();
    }

    @NotNull
    public Component getText() {
        return this.text;
    }

    @NotNull
    public Optional<KeyMapping> asKeyBinding() {
        return Optional.ofNullable(this.mcKeyBinding);
    }

    public String toString() {
        return "ButtonBinding{id=\"" + this.key + "\",hasCooldown=" + this.hasCooldown + "}";
    }

    public static int axisAsButton(int axis, boolean positive) {
        return positive ? 100 + axis : 200 + axis;
    }

    public static boolean isAxis(int button) {
        return (button %= 500) >= 100;
    }

    public static int controller2Button(int button) {
        return 500 + button;
    }

    public static void init(@NotNull Options options) {
        ButtonBinding.ATTACK.mcKeyBinding = options.keyAttack;
        ButtonBinding.BACK.mcKeyBinding = options.keyDown;
        ButtonBinding.CHAT.mcKeyBinding = options.keyChat;
        ButtonBinding.DROP_ITEM.mcKeyBinding = options.keyDrop;
        ButtonBinding.FORWARD.mcKeyBinding = options.keyUp;
        ButtonBinding.INVENTORY.mcKeyBinding = options.keyInventory;
        ButtonBinding.JUMP.mcKeyBinding = options.keyJump;
        ButtonBinding.LEFT.mcKeyBinding = options.keyLeft;
        ButtonBinding.PICK_BLOCK.mcKeyBinding = options.keyPickItem;
        ButtonBinding.PLAYER_LIST.mcKeyBinding = options.keyPlayerList;
        ButtonBinding.RIGHT.mcKeyBinding = options.keyRight;
        ButtonBinding.SCREENSHOT.mcKeyBinding = options.keyScreenshot;
        ButtonBinding.SNEAK.mcKeyBinding = options.keyShift;
        ButtonBinding.SPRINT.mcKeyBinding = options.keySprint;
        ButtonBinding.SWAP_HANDS.mcKeyBinding = options.keySwapOffhand;
        ButtonBinding.TOGGLE_PERSPECTIVE.mcKeyBinding = options.keyTogglePerspective;
        ButtonBinding.USE.mcKeyBinding = options.keyUse;
    }

    @NotNull
    public static Component getLocalizedButtonName(int button) {
        return switch (button % 500) {
            case -1 -> Component.translatable((String)"key.keyboard.unknown");
            case 0 -> Component.translatable((String)"midnightcontrols.button.a");
            case 1 -> Component.translatable((String)"midnightcontrols.button.b");
            case 2 -> Component.translatable((String)"midnightcontrols.button.x");
            case 3 -> Component.translatable((String)"midnightcontrols.button.y");
            case 4 -> Component.translatable((String)"midnightcontrols.button.left_bumper");
            case 5 -> Component.translatable((String)"midnightcontrols.button.right_bumper");
            case 6 -> Component.translatable((String)"midnightcontrols.button.back");
            case 7 -> Component.translatable((String)"midnightcontrols.button.start");
            case 8 -> Component.translatable((String)"midnightcontrols.button.guide");
            case 9 -> Component.translatable((String)"midnightcontrols.button.left_thumb");
            case 10 -> Component.translatable((String)"midnightcontrols.button.right_thumb");
            case 11 -> Component.translatable((String)"midnightcontrols.button.dpad_up");
            case 12 -> Component.translatable((String)"midnightcontrols.button.dpad_right");
            case 13 -> Component.translatable((String)"midnightcontrols.button.dpad_down");
            case 14 -> Component.translatable((String)"midnightcontrols.button.dpad_left");
            case 100 -> Component.translatable((String)"midnightcontrols.axis.left_x+");
            case 101 -> Component.translatable((String)"midnightcontrols.axis.left_y+");
            case 102 -> Component.translatable((String)"midnightcontrols.axis.right_x+");
            case 103 -> Component.translatable((String)"midnightcontrols.axis.right_y+");
            case 104 -> Component.translatable((String)"midnightcontrols.axis.left_trigger");
            case 105 -> Component.translatable((String)"midnightcontrols.axis.right_trigger");
            case 200 -> Component.translatable((String)"midnightcontrols.axis.left_x-");
            case 201 -> Component.translatable((String)"midnightcontrols.axis.left_y-");
            case 202 -> Component.translatable((String)"midnightcontrols.axis.right_x-");
            case 203 -> Component.translatable((String)"midnightcontrols.axis.right_y-");
            case 15 -> Component.translatable((String)"midnightcontrols.button.l4");
            case 16 -> Component.translatable((String)"midnightcontrols.button.l5");
            case 17 -> Component.translatable((String)"midnightcontrols.button.r4");
            case 18 -> Component.translatable((String)"midnightcontrols.button.r5");
            default -> Component.translatable((String)"midnightcontrols.button.unknown", (Object[])new Object[]{button});
        };
    }

    public static Builder builder(@NotNull ResourceLocation identifier) {
        return new Builder(identifier);
    }

    static {
        ATTACK = new Builder("attack").buttons(ButtonBinding.axisAsButton(5, true)).onlyInGame().register();
        BACK = new Builder("back").buttons(ButtonBinding.axisAsButton(1, false)).action(MovementHandler.HANDLER).onlyInGame().register();
        CHAT = new Builder("chat").buttons(12).onlyInGame().cooldown().register();
        CONTROLS_RING = new Builder("controls_ring").buttons(8).onlyInGame().cooldown().action((client, button1, value, action) -> {
            if (action.isPressed()) {
                MidnightControlsClient.ring.loadFromUnbound();
                client.setScreen((Screen)new RingScreen());
            }
            if (action.isUnpressed() && client.screen != null) {
                client.screen.onClose();
            }
            return true;
        }).register();
        DROP_ITEM = new Builder("drop_item").buttons(1).onlyInGame().cooldown().register();
        FORWARD = new Builder("forward").buttons(ButtonBinding.axisAsButton(1, true)).action(MovementHandler.HANDLER).onlyInGame().register();
        HOTBAR_LEFT = new Builder("hotbar_left").buttons(4).action(InputHandlers.handleHotbar(false)).onlyInGame().cooldown().register();
        HOTBAR_RIGHT = new Builder("hotbar_right").buttons(5).action(InputHandlers.handleHotbar(true)).onlyInGame().cooldown().register();
        INVENTORY = new Builder("inventory").buttons(3).onlyInGame().cooldown().register();
        EXIT = new Builder("exit").buttons(1).filter(buttonBinding -> MidnightControlsClient.client.screen != null && buttonBinding.cooldown == 0 && ButtonBinding.INVENTORY.cooldown == 0).action(InputHandlers.handleExit()).cooldown().register();
        JUMP = new Builder("jump").buttons(0).onlyInGame().register();
        LEFT = new Builder("left").buttons(ButtonBinding.axisAsButton(0, false)).action(MovementHandler.HANDLER).onlyInGame().register();
        PAUSE_GAME = new Builder("pause_game").buttons(7).action(InputHandlers::handlePauseGame).cooldown().register();
        PICK_BLOCK = new Builder("pick_block").buttons(14).onlyInGame().cooldown().register();
        PLAYER_LIST = new Builder("player_list").buttons(6).onlyInGame().register();
        RIGHT = new Builder("right").buttons(ButtonBinding.axisAsButton(0, true)).action(MovementHandler.HANDLER).onlyInGame().register();
        SCREENSHOT = new Builder("screenshot").buttons(11, 0).action(InputHandlers::handleScreenshot).cooldown().register();
        DEBUG_SCREEN = new Builder("debug_screen").buttons(11, 1).action((client, binding, value, action) -> {
            if (action == ButtonState.PRESS) {
                client.gui.getDebugOverlay().toggleOverlay();
            }
            return true;
        }).cooldown().register();
        SLOT_DOWN = new Builder("slot_down").buttons(13).action(InputHandlers.handleInventorySlotPad(1)).onlyInInventory().cooldown().register();
        SLOT_LEFT = new Builder("slot_left").buttons(14).action(InputHandlers.handleInventorySlotPad(3)).onlyInInventory().cooldown().register();
        SLOT_RIGHT = new Builder("slot_right").buttons(12).action(InputHandlers.handleInventorySlotPad(2)).onlyInInventory().cooldown().register();
        SLOT_UP = new Builder("slot_up").buttons(11).action(InputHandlers.handleInventorySlotPad(0)).onlyInInventory().cooldown().register();
        SNEAK = new Builder("sneak").buttons(10).actions(InputHandlers::handleToggleSneak).onlyInGame().cooldown().register();
        SPRINT = new Builder("sprint").buttons(9).actions(InputHandlers::handleToggleSprint).onlyInGame().cooldown().register();
        SWAP_HANDS = new Builder("swap_hands").buttons(2).onlyInGame().cooldown().register();
        TAB_LEFT = new Builder("tab_back").buttons(4).action(InputHandlers.handleHotbar(false)).filter(Predicates.or(InputHandlers::inInventory, InputHandlers::inAdvancements).or(binding -> MidnightControlsClient.client.screen != null)).cooldown().register();
        TAB_RIGHT = new Builder("tab_next").buttons(5).action(InputHandlers.handleHotbar(true)).filter(Predicates.or(InputHandlers::inInventory, InputHandlers::inAdvancements).or(binding -> MidnightControlsClient.client.screen != null)).cooldown().register();
        PAGE_LEFT = new Builder("page_back").buttons(ButtonBinding.axisAsButton(4, true)).action(InputHandlers.handlePage(false)).filter(InputHandlers::inInventory).cooldown(30).register();
        PAGE_RIGHT = new Builder("page_next").buttons(ButtonBinding.axisAsButton(5, true)).action(InputHandlers.handlePage(true)).filter(InputHandlers::inInventory).cooldown(30).register();
        TAKE = new Builder("take").buttons(2).action(InputHandlers.handleActions()).filter(InputHandlers::inInventory).cooldown().register();
        TAKE_ALL = new Builder("take_all").buttons(0).action(InputHandlers.handleActions()).filter(InputHandlers::inInventory).cooldown().register();
        QUICK_MOVE = new Builder("quick_move").buttons(3).action(InputHandlers.handleActions()).filter(InputHandlers::inInventory).cooldown().register();
        TOGGLE_PERSPECTIVE = new Builder("toggle_perspective").filter(InputHandlers::inGame).buttons(11, 3).cooldown().register();
        USE = new Builder("use").buttons(ButtonBinding.axisAsButton(4, true)).register();
        MOVEMENT_CATEGORY = InputManager.registerDefaultCategory("key.categories.movement", category -> category.registerAllBindings(FORWARD, BACK, LEFT, RIGHT, JUMP, SNEAK, SPRINT));
        GAMEPLAY_CATEGORY = InputManager.registerDefaultCategory("key.categories.gameplay", category -> category.registerAllBindings(ATTACK, PICK_BLOCK, USE));
        INVENTORY_CATEGORY = InputManager.registerDefaultCategory("key.categories.inventory", category -> category.registerAllBindings(EXIT, DROP_ITEM, HOTBAR_LEFT, HOTBAR_RIGHT, INVENTORY, SWAP_HANDS, TAB_LEFT, TAB_RIGHT, PAGE_LEFT, PAGE_RIGHT, TAKE, TAKE_ALL, QUICK_MOVE, SLOT_UP, SLOT_DOWN, SLOT_LEFT, SLOT_RIGHT));
        MULTIPLAYER_CATEGORY = InputManager.registerDefaultCategory("key.categories.multiplayer", category -> category.registerAllBindings(CHAT, PLAYER_LIST));
        MISC_CATEGORY = InputManager.registerDefaultCategory("key.categories.misc", category -> category.registerAllBindings(SCREENSHOT, TOGGLE_PERSPECTIVE, PAUSE_GAME, DEBUG_SCREEN, CONTROLS_RING));
    }

    public static class Builder {
        private final String key;
        private int[] buttons = new int[0];
        private final List<PressAction> actions = new ArrayList<PressAction>();
        private Predicate<ButtonBinding> filter = Predicates.alwaysTrue();
        private boolean cooldown = false;
        private int cooldownLength = 5;
        private ButtonCategory category = null;
        private KeyMapping mcBinding = null;

        public Builder(@NotNull String key) {
            this.key = key;
            this.unbound();
        }

        public Builder(@NotNull ResourceLocation identifier) {
            this(identifier.getNamespace() + "." + identifier.getPath());
        }

        @Deprecated
        public Builder(@NotNull Identifier identifier) {
            this(identifier.getNamespace() + "." + identifier.getName());
        }

        public Builder buttons(int ... buttons) {
            this.buttons = buttons;
            return this;
        }

        public Builder unbound() {
            return this.buttons(-1);
        }

        public Builder actions(PressAction ... actions) {
            this.actions.addAll(Arrays.asList(actions));
            return this;
        }

        public Builder action(@NotNull PressAction action) {
            this.actions.add(action);
            return this;
        }

        public Builder filter(@NotNull Predicate<ButtonBinding> filter) {
            this.filter = filter;
            return this;
        }

        public Builder onlyInGame() {
            return this.filter(InputHandlers::inGame);
        }

        public Builder onlyInInventory() {
            return this.filter(InputHandlers::inInventory);
        }

        public Builder cooldown(boolean cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        public Builder cooldown(int cooldownLength) {
            this.cooldownLength = cooldownLength;
            this.cooldown = true;
            return this;
        }

        public Builder cooldown() {
            return this.cooldown(true);
        }

        public Builder category(@Nullable ButtonCategory category) {
            this.category = category;
            return this;
        }

        public Builder linkKeybind(@Nullable KeyMapping binding) {
            this.mcBinding = binding;
            return this;
        }

        public ButtonBinding build() {
            ButtonBinding binding = new ButtonBinding(this.key, this.buttons, this.actions, this.filter, this.cooldown, this.cooldownLength);
            if (this.category != null) {
                this.category.registerBinding(binding);
            }
            if (this.mcBinding != null) {
                binding.setKeyBinding(this.mcBinding);
            }
            return binding;
        }

        public ButtonBinding register() {
            return InputManager.registerBinding(this.build());
        }
    }
}

