/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client.controller;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.pipeline.RenderTarget;
import eu.midnightdust.midnightcontrols.client.MidnightControlsClient;
import eu.midnightdust.midnightcontrols.client.MidnightInput;
import eu.midnightdust.midnightcontrols.client.compat.MidnightControlsCompat;
import eu.midnightdust.midnightcontrols.client.controller.ButtonBinding;
import eu.midnightdust.midnightcontrols.client.controller.InputManager;
import eu.midnightdust.midnightcontrols.client.controller.PressAction;
import eu.midnightdust.midnightcontrols.client.enums.ButtonState;
import eu.midnightdust.midnightcontrols.client.gui.RingScreen;
import eu.midnightdust.midnightcontrols.client.mixin.AdvancementsScreenAccessor;
import eu.midnightdust.midnightcontrols.client.mixin.CreativeInventoryScreenAccessor;
import eu.midnightdust.midnightcontrols.client.mixin.RecipeBookWidgetAccessor;
import eu.midnightdust.midnightcontrols.client.mixin.TabNavigationWidgetAccessor;
import eu.midnightdust.midnightcontrols.client.touch.gui.TouchscreenOverlay;
import eu.midnightdust.midnightcontrols.client.util.HandledScreenAccessor;
import eu.midnightdust.midnightcontrols.client.util.InventoryUtil;
import eu.midnightdust.midnightcontrols.client.util.ToggleSneakSprintUtil;
import eu.midnightdust.midnightcontrols.client.util.platform.ItemGroupUtil;
import java.io.File;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import net.minecraft.client.gui.components.tabs.TabNavigationBar;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.advancements.AdvancementTab;
import net.minecraft.client.gui.screens.advancements.AdvancementsScreen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.AbstractFurnaceScreen;
import net.minecraft.client.gui.screens.inventory.CraftingScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeBookTabButton;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.NotNull;

public class InputHandlers {
    private InputHandlers() {
    }

    public static PressAction handleHotbar(boolean next) {
        return (client, button, value, action) -> {
            if (action == ButtonState.RELEASE) {
                return false;
            }
            if (client.screen == null && client.player != null) {
                if (!client.player.isSpectator()) {
                    if (next) {
                        client.player.getInventory().swapPaint(-1.0);
                    } else {
                        client.player.getInventory().swapPaint(1.0);
                    }
                } else if (client.gui.getSpectatorGui().isMenuActive()) {
                    client.gui.getSpectatorGui().onMouseScrolled(next ? -1 : 1);
                } else {
                    float g = Mth.clamp((float)(client.player.getAbilities().getFlyingSpeed() + (float)(next ? 1 : -1) * 0.005f), (float)0.0f, (float)0.2f);
                    client.player.getAbilities().setFlyingSpeed(g);
                }
                return true;
            }
            if (!(client.screen instanceof RingScreen)) {
                Screen patt0$temp = client.screen;
                if (patt0$temp instanceof CreativeInventoryScreenAccessor) {
                    CreativeInventoryScreenAccessor inventory = (CreativeInventoryScreenAccessor)patt0$temp;
                    inventory.midnightcontrols$setSelectedTab(ItemGroupUtil.cycleTab(next, client));
                    return true;
                }
                if (client.screen instanceof InventoryScreen || client.screen instanceof CraftingScreen || client.screen instanceof AbstractFurnaceScreen) {
                    RecipeBookComponent recipeBook;
                    Screen patt1$temp = client.screen;
                    if (patt1$temp instanceof InventoryScreen) {
                        InventoryScreen inventoryScreen = (InventoryScreen)patt1$temp;
                        recipeBook = inventoryScreen.getRecipeBookComponent();
                    } else {
                        Screen patt2$temp = client.screen;
                        if (patt2$temp instanceof CraftingScreen) {
                            CraftingScreen craftingScreen = (CraftingScreen)patt2$temp;
                            recipeBook = craftingScreen.getRecipeBookComponent();
                        } else {
                            recipeBook = ((AbstractFurnaceScreen)client.screen).getRecipeBookComponent();
                        }
                    }
                    RecipeBookWidgetAccessor recipeBookAccessor = (RecipeBookWidgetAccessor)recipeBook;
                    List<RecipeBookTabButton> tabs = recipeBookAccessor.getTabButtons();
                    RecipeBookTabButton currentTab = recipeBookAccessor.getCurrentTab();
                    if (currentTab == null || !recipeBook.isVisible()) {
                        return MidnightControlsCompat.handleTabs(client.screen, next);
                    }
                    int nextTab = tabs.indexOf(currentTab) + (next ? 1 : -1);
                    if (nextTab < 0) {
                        nextTab = tabs.size() - 1;
                    } else if (nextTab >= tabs.size()) {
                        nextTab = 0;
                    }
                    currentTab.setStateTriggered(false);
                    currentTab = tabs.get(nextTab);
                    recipeBookAccessor.setCurrentTab(currentTab);
                    currentTab.setStateTriggered(true);
                    recipeBookAccessor.midnightcontrols$refreshResults(true);
                    return true;
                }
                Screen patt1$temp = client.screen;
                if (patt1$temp instanceof AdvancementsScreenAccessor) {
                    AdvancementsScreenAccessor screen = (AdvancementsScreenAccessor)patt1$temp;
                    List<AdvancementTab> tabs = screen.getTabs().values().stream().distinct().toList();
                    AdvancementTab tab = screen.getSelectedTab();
                    if (tab == null) {
                        return false;
                    }
                    for (int i = 0; i < tabs.size(); ++i) {
                        if (!tabs.get(i).equals(tab)) continue;
                        int nextTab = i + (next ? 1 : -1);
                        if (nextTab < 0) {
                            nextTab = tabs.size() - 1;
                        } else if (nextTab >= tabs.size()) {
                            nextTab = 0;
                        }
                        screen.getAdvancementManager().setSelectedTab(tabs.get(nextTab).getRootNode().holder(), true);
                        break;
                    }
                    return true;
                }
                if (client.screen != null && client.screen.children().stream().anyMatch(e -> e instanceof TabNavigationBar)) {
                    return Lists.newCopyOnWriteArrayList((Iterable)client.screen.children()).stream().anyMatch(e -> {
                        if (e instanceof TabNavigationBar) {
                            TabNavigationBar tabs = (TabNavigationBar)e;
                            TabNavigationWidgetAccessor accessor = (TabNavigationWidgetAccessor)tabs;
                            int tabIndex = accessor.getTabs().indexOf((Object)accessor.getTabManager().getCurrentTab());
                            if (next ? tabIndex + 1 < accessor.getTabs().size() : tabIndex > 0) {
                                if (next) {
                                    tabs.selectTab(tabIndex + 1, true);
                                } else {
                                    tabs.selectTab(tabIndex - 1, true);
                                }
                                return true;
                            }
                        }
                        return false;
                    });
                }
                return MidnightControlsCompat.handleTabs(client.screen, next);
            }
            MidnightControlsClient.ring.cyclePage(next);
            return false;
        };
    }

    public static PressAction handlePage(boolean next) {
        return (client, button, value, action) -> {
            if (action == ButtonState.RELEASE) {
                return false;
            }
            Screen patt0$temp = client.screen;
            if (patt0$temp instanceof CreativeModeInventoryScreen) {
                CreativeModeInventoryScreen creativeScreen = (CreativeModeInventoryScreen)patt0$temp;
                return ItemGroupUtil.cyclePage(next, creativeScreen);
            }
            return MidnightControlsCompat.handlePages(client.screen, next);
        };
    }

    public static PressAction handleExit() {
        return (client, button, value, action) -> {
            if (client.screen != null && client.screen.getClass() != TitleScreen.class) {
                if (!MidnightControlsCompat.handleMenuBack(client, client.screen) && !MidnightControlsClient.input.tryGoBack(client.screen)) {
                    client.screen.onClose();
                }
                return true;
            }
            return false;
        };
    }

    public static PressAction handleActions() {
        return (client, button, value, action) -> {
            int slotId;
            double y;
            Screen patt0$temp = client.screen;
            if (!(patt0$temp instanceof AbstractContainerScreen)) {
                return false;
            }
            AbstractContainerScreen screen = (AbstractContainerScreen)patt0$temp;
            if (client.gameMode == null || client.player == null) {
                return false;
            }
            if (MidnightControlsClient.input.inventoryInteractionCooldown > 0) {
                return true;
            }
            HandledScreenAccessor accessor = (HandledScreenAccessor)screen;
            double x = client.mouseHandler.xpos() * (double)client.getWindow().getGuiScaledWidth() / (double)client.getWindow().getScreenWidth();
            Slot slot = accessor.midnightcontrols$getSlotAt(x, y = client.mouseHandler.ypos() * (double)client.getWindow().getGuiScaledHeight() / (double)client.getWindow().getScreenHeight());
            if (slot == null) {
                if (button.getName().equals("take_all")) {
                    return false;
                }
                slotId = accessor.midnightcontrols$isClickOutsideBounds(x, y, accessor.getX(), accessor.getY(), 0) ? -999 : -1;
            } else {
                slotId = slot.index;
            }
            ClickType actionType = ClickType.PICKUP;
            int clickData = 0;
            MidnightControlsClient.input.inventoryInteractionCooldown = 5;
            switch (button.getName()) {
                case "take_all": {
                    if (!(screen instanceof CreativeModeInventoryScreen) || slot == null || !((CreativeInventoryScreenAccessor)((Object)accessor)).midnightcontrols$isCreativeInventorySlot(slot) && !MidnightControlsCompat.streamCompatHandlers().anyMatch(handler -> handler.isCreativeSlot(screen, slot))) break;
                    actionType = ClickType.CLONE;
                    break;
                }
                case "take": {
                    clickData = 1;
                    break;
                }
                case "quick_move": {
                    actionType = ClickType.QUICK_MOVE;
                    break;
                }
                default: {
                    return false;
                }
            }
            accessor.midnightcontrols$onMouseClick(slot, slotId, clickData, actionType);
            return true;
        };
    }

    public static boolean handlePauseGame(@NotNull Minecraft client, @NotNull ButtonBinding binding, float value, @NotNull ButtonState action) {
        if (action == ButtonState.PRESS) {
            if (client.screen == null || client.screen instanceof RingScreen) {
                client.pauseGame(false);
            } else if (client.screen instanceof AbstractContainerScreen && client.player != null) {
                client.player.closeContainer();
            } else {
                client.screen.onClose();
            }
        }
        return true;
    }

    public static boolean handleScreenshot(@NotNull Minecraft client, @NotNull ButtonBinding binding, float value, @NotNull ButtonState action) {
        if (action == ButtonState.RELEASE) {
            Screenshot.grab((File)client.gameDirectory, (RenderTarget)client.getMainRenderTarget(), text -> client.execute(() -> client.gui.getChat().addMessage(text)));
        }
        return true;
    }

    public static boolean handleToggleSneak(@NotNull Minecraft client, @NotNull ButtonBinding button, float value, @NotNull ButtonState action) {
        return ToggleSneakSprintUtil.toggleSneak(button);
    }

    public static boolean handleToggleSprint(@NotNull Minecraft client, @NotNull ButtonBinding button, float value, @NotNull ButtonState action) {
        return ToggleSneakSprintUtil.toggleSprint(button);
    }

    public static PressAction handleInventorySlotPad(int direction) {
        return (client, binding, value, action) -> {
            AbstractContainerScreen inventory;
            block5: {
                block4: {
                    Screen patt0$temp = client.screen;
                    if (!(patt0$temp instanceof AbstractContainerScreen)) break block4;
                    inventory = (AbstractContainerScreen)patt0$temp;
                    if (action != ButtonState.RELEASE) break block5;
                }
                return false;
            }
            HandledScreenAccessor accessor = (HandledScreenAccessor)inventory;
            Optional<Slot> closestSlot = InventoryUtil.findClosestSlot(inventory, direction);
            if (closestSlot.isPresent()) {
                Slot slot = closestSlot.get();
                int x = accessor.getX() + slot.x + 8;
                int y = accessor.getY() + slot.y + 8;
                InputManager.queueMousePosition((double)x * (double)client.getWindow().getScreenWidth() / (double)client.getWindow().getGuiScaledWidth(), (double)y * (double)client.getWindow().getScreenHeight() / (double)client.getWindow().getGuiScaledHeight());
                return true;
            }
            return false;
        };
    }

    public static boolean always(@NotNull ButtonBinding binding) {
        return true;
    }

    public static boolean inGame(@NotNull ButtonBinding binding) {
        return MidnightControlsClient.client.screen == null && MidnightControlsClient.input.screenCloseCooldown <= 0 || MidnightControlsClient.client.screen instanceof TouchscreenOverlay || MidnightControlsClient.client.screen instanceof RingScreen;
    }

    public static boolean inNonInteractiveScreens(@NotNull ButtonBinding binding) {
        if (MidnightControlsClient.client.screen == null) {
            return false;
        }
        return !MidnightInput.isScreenInteractive(MidnightControlsClient.client.screen);
    }

    public static boolean inInventory(@NotNull ButtonBinding binding) {
        return MidnightControlsClient.client.screen instanceof AbstractContainerScreen;
    }

    public static boolean inAdvancements(@NotNull ButtonBinding binding) {
        return MidnightControlsClient.client.screen instanceof AdvancementsScreen;
    }
}

