/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client.controller;

import eu.midnightdust.midnightcontrols.client.MidnightControlsConfig;
import eu.midnightdust.midnightcontrols.client.controller.ButtonBinding;
import eu.midnightdust.midnightcontrols.client.controller.PressAction;
import eu.midnightdust.midnightcontrols.client.enums.ButtonState;
import eu.midnightdust.midnightcontrols.client.util.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.attributes.Attributes;
import org.jetbrains.annotations.NotNull;

public final class MovementHandler
implements PressAction {
    public static final MovementHandler HANDLER = new MovementHandler();
    private boolean shouldOverrideMovement = false;
    private boolean pressingForward = false;
    private boolean pressingBack = false;
    private boolean pressingLeft = false;
    private boolean pressingRight = false;
    private float slowdownFactor = 1.0f;
    private float movementForward = 0.0f;
    private float movementSideways = 0.0f;
    private final MathUtil.PolarUtil polarUtil = new MathUtil.PolarUtil();

    private MovementHandler() {
    }

    public void applyMovement(@NotNull LocalPlayer player) {
        if (!this.shouldOverrideMovement) {
            return;
        }
        player.input.up = this.pressingForward;
        player.input.down = this.pressingBack;
        player.input.left = this.pressingLeft;
        player.input.right = this.pressingRight;
        this.polarUtil.calculate(this.movementSideways, this.movementForward, this.slowdownFactor);
        player.input.forwardImpulse = this.polarUtil.polarY;
        player.input.leftImpulse = this.polarUtil.polarX;
        this.shouldOverrideMovement = false;
    }

    @Override
    public boolean press(@NotNull Minecraft client, @NotNull ButtonBinding button, float value, @NotNull ButtonState action) {
        if (client.screen != null || client.player == null) {
            this.shouldOverrideMovement = false;
            return false;
        }
        int direction = 0;
        if (button == ButtonBinding.FORWARD || button == ButtonBinding.LEFT) {
            direction = 1;
        } else if (button == ButtonBinding.BACK || button == ButtonBinding.RIGHT) {
            direction = -1;
        }
        if (action.isUnpressed()) {
            direction = 0;
        }
        boolean bl = this.shouldOverrideMovement = direction != 0;
        if (!MidnightControlsConfig.analogMovement) {
            value = 1.0f;
        }
        float f = this.slowdownFactor = client.player.isMovingSlowly() ? Mth.clamp((float)(0.3f + (float)client.player.getAttributeValue(Attributes.SNEAKING_SPEED)), (float)0.0f, (float)1.0f) : 1.0f;
        if (button == ButtonBinding.FORWARD || button == ButtonBinding.BACK) {
            this.pressingForward = direction > 0;
            this.pressingBack = direction < 0;
            this.movementForward = (float)direction * value;
        } else {
            this.pressingLeft = direction > 0;
            this.pressingRight = direction < 0;
            this.movementSideways = (float)direction * value;
        }
        return this.shouldOverrideMovement;
    }
}

