/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client.enums;

import java.util.Arrays;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public enum ControllerType {
    DEFAULT(0),
    DUALSHOCK(1),
    DUALSENSE(2),
    SWITCH(3),
    XBOX_360(4),
    XBOX(5),
    STEAM_DECK(6),
    STEAM_CONTROLLER(7),
    OUYA(8),
    NUMBERED(9);

    private final int id;
    private final Component text;

    private ControllerType(int id) {
        this.id = id;
        this.text = Component.translatable((String)("midnightcontrols.controller_type." + this.getName()));
    }

    private ControllerType(int id, Component text) {
        this.id = id;
        this.text = text;
    }

    public int getId() {
        return this.id;
    }

    @NotNull
    public ControllerType next() {
        ControllerType[] v = ControllerType.values();
        if (v.length == this.ordinal() + 1) {
            return v[0];
        }
        return v[this.ordinal() + 1];
    }

    @NotNull
    public Component getTranslatedText() {
        return this.text;
    }

    @NotNull
    public String getName() {
        return this.name().toLowerCase();
    }

    @NotNull
    public static Optional<ControllerType> byId(@NotNull String id) {
        return Arrays.stream(ControllerType.values()).filter(mode -> mode.getName().equalsIgnoreCase(id)).findFirst();
    }
}

