/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import eu.midnightdust.midnightcontrols.MidnightControlsFeature;
import eu.midnightdust.midnightcontrols.client.MidnightControlsClient;
import eu.midnightdust.midnightcontrols.client.MidnightControlsConfig;
import eu.midnightdust.midnightcontrols.client.touch.gui.TouchscreenOverlay;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public abstract class MinecraftClientMixin {
    @Shadow
    @Nullable
    public HitResult hitResult;
    @Shadow
    @Nullable
    public LocalPlayer player;
    @Shadow
    @Nullable
    public MultiPlayerGameMode gameMode;
    @Shadow
    @Final
    public GameRenderer gameRenderer;
    @Shadow
    private int rightClickDelay;
    @Unique
    private BlockPos midnightcontrols$lastTargetPos;
    @Unique
    private Vec3 midnightcontrols$lastPos;
    @Unique
    private Direction midnightcontrols$lastTargetSide;

    @Shadow
    public abstract void setScreen(Screen var1);

    @Inject(method={"<init>(Lnet/minecraft/client/main/GameConfig;)V"}, at={@At(value="RETURN")})
    private void onInit(CallbackInfo ci) {
        MidnightControlsClient.onMcInit((Minecraft)this);
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void onStartTick(CallbackInfo ci) {
        if (this.player == null) {
            return;
        }
        if (!MidnightControlsFeature.FAST_BLOCK_PLACING.isAvailable()) {
            return;
        }
        if (this.midnightcontrols$lastPos == null) {
            this.midnightcontrols$lastPos = this.player.position();
        }
        int cooldown = this.rightClickDelay;
        if (this.hitResult != null && this.hitResult.getType() == HitResult.Type.BLOCK && this.player.getAbilities().flying) {
            boolean backwardsBlockPlacing;
            BlockHitResult hitResult = (BlockHitResult)this.hitResult;
            BlockPos targetPos = hitResult.getBlockPos();
            Direction side = hitResult.getDirection();
            boolean sidewaysBlockPlacing = this.midnightcontrols$lastTargetPos == null || !targetPos.equals((Object)this.midnightcontrols$lastTargetPos.relative(this.midnightcontrols$lastTargetSide));
            boolean bl = backwardsBlockPlacing = this.player.input.forwardImpulse < 0.0f && (this.midnightcontrols$lastTargetPos == null || targetPos.equals((Object)this.midnightcontrols$lastTargetPos.relative(this.midnightcontrols$lastTargetSide)));
            if (cooldown > 1 && !targetPos.equals((Object)this.midnightcontrols$lastTargetPos) && (sidewaysBlockPlacing || backwardsBlockPlacing)) {
                this.rightClickDelay = 1;
            }
            this.midnightcontrols$lastTargetPos = targetPos.immutable();
            this.midnightcontrols$lastTargetSide = side;
        }
        this.midnightcontrols$lastPos = this.player.position();
    }

    @Inject(at={@At(value="TAIL")}, method={"setScreen(Lnet/minecraft/client/gui/screens/Screen;)V"})
    private void setScreen(Screen screen, CallbackInfo info) {
        if (MidnightControlsConfig.hideNormalMouse) {
            if (screen != null && !(screen instanceof TouchscreenOverlay)) {
                GLFW.glfwSetInputMode((long)Minecraft.getInstance().getWindow().getWindow(), (int)208897, (int)212994);
            } else {
                GLFW.glfwSetInputMode((long)Minecraft.getInstance().getWindow().getWindow(), (int)208897, (int)212995);
            }
        }
        MidnightControlsClient.onScreenOpen(screen);
    }

    @Inject(method={"startUseItem()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/phys/HitResult;getType()Lnet/minecraft/world/phys/HitResult$Type;")}, cancellable=true)
    private void onItemUse(CallbackInfo ci, @Local InteractionHand hand, @Local ItemStack stackInHand) {
        if (this.player != null && !stackInHand.isEmpty() && this.player.getViewXRot(0.0f) > 35.0f && MidnightControlsClient.reacharound.isReacharoundAvailable() && this.hitResult != null && this.hitResult.getType() == HitResult.Type.MISS && this.player.onGround() && !stackInHand.isEmpty() && stackInHand.getItem() instanceof BlockItem) {
            BlockHitResult hitResult = MidnightControlsClient.reacharound.getLastReacharoundResult();
            if (hitResult == null || this.gameMode == null) {
                return;
            }
            hitResult = MidnightControlsClient.reacharound.withSideForReacharound(hitResult, stackInHand);
            int previousStackCount = stackInHand.getCount();
            InteractionResult result = this.gameMode.useItemOn(this.player, hand, hitResult);
            if (result.consumesAction()) {
                if (result.shouldSwing()) {
                    this.player.swing(hand);
                    if (!stackInHand.isEmpty() && (stackInHand.getCount() != previousStackCount || this.gameMode.hasInfiniteItems())) {
                        this.gameRenderer.itemInHandRenderer.itemUsed(hand);
                    }
                }
                ci.cancel();
            }
            if (result == InteractionResult.FAIL) {
                ci.cancel();
            }
        }
    }
}

