/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client.mixin;

import com.mojang.blaze3d.Blaze3D;
import eu.midnightdust.midnightcontrols.ControlsMode;
import eu.midnightdust.midnightcontrols.client.MidnightControlsClient;
import eu.midnightdust.midnightcontrols.client.MidnightControlsConfig;
import eu.midnightdust.midnightcontrols.client.mixin.MouseAccessor;
import eu.midnightdust.midnightcontrols.client.mouse.EyeTrackerHandler;
import eu.midnightdust.midnightcontrols.client.touch.TouchInput;
import eu.midnightdust.midnightcontrols.client.touch.TouchUtils;
import eu.midnightdust.midnightcontrols.client.touch.gui.TouchscreenOverlay;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.util.SmoothDouble;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ThrowablePotionItem;
import net.minecraft.world.item.UseAnim;
import org.lwjgl.glfw.GLFW;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MouseHandler.class})
public abstract class MouseMixin
implements MouseAccessor {
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    private double ypos;
    @Shadow
    private double accumulatedDX;
    @Shadow
    private double accumulatedDY;
    @Shadow
    private double xpos;
    @Shadow
    private boolean mouseGrabbed;
    @Shadow
    private boolean ignoreFirstMove;
    @Shadow
    private double mousePressedTime;
    @Shadow
    @Final
    private SmoothDouble smoothTurnX;
    @Shadow
    @Final
    private SmoothDouble smoothTurnY;
    @Shadow
    private boolean isLeftPressed;

    @Inject(method={"onPress(JIII)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void midnightcontrols$onMouseButton(long window, int button, int action, int mods, CallbackInfo ci) {
        if (window != this.minecraft.getWindow().getWindow()) {
            return;
        }
        if (action == 1 && button == 3 && this.minecraft.screen != null) {
            MidnightControlsClient.input.tryGoBack(this.minecraft.screen);
        } else if ((this.minecraft.screen == null && MidnightControlsConfig.doMixedInput() || this.minecraft.screen instanceof TouchscreenOverlay) && this.minecraft.player != null && button == 0) {
            double mouseX = this.xpos / this.minecraft.getWindow().getGuiScale();
            double mouseY = this.ypos / this.minecraft.getWindow().getGuiScale();
            int centerX = this.minecraft.getWindow().getGuiScaledWidth() / 2;
            if (action == 1 && mouseY >= (double)(this.minecraft.getWindow().getGuiScaledHeight() - 22) && mouseX >= (double)(centerX - 90) && mouseX <= (double)(centerX + 90)) {
                for (int slot = 0; slot < 9; ++slot) {
                    int slotX = centerX - 90 + slot * 20 + 2;
                    if (!(mouseX >= (double)slotX) || !(mouseX <= (double)(slotX + 20))) continue;
                    this.minecraft.player.getInventory().selected = slot;
                    ci.cancel();
                    return;
                }
            }
            if (action == 1) {
                TouchInput.clickStartTime = System.currentTimeMillis();
                boolean bl = false;
                Screen screen = this.minecraft.screen;
                if (screen instanceof TouchscreenOverlay) {
                    TouchscreenOverlay overlay = (TouchscreenOverlay)screen;
                    bl = overlay.mouseClicked(mouseX, mouseY, button);
                }
                if (!bl) {
                    TouchInput.firstHitResult = TouchUtils.getTargetedObject(mouseX, mouseY);
                }
                if (this.minecraft.screen == null) {
                    ci.cancel();
                }
            } else if (TouchInput.mouseReleased(mouseX, mouseY, button)) {
                ci.cancel();
            }
        }
    }

    @Inject(method={"isMouseGrabbed()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void midnightcontrols$isCursorLocked(CallbackInfoReturnable<Boolean> ci) {
        if (this.minecraft.screen == null && MidnightControlsConfig.controlsMode == ControlsMode.CONTROLLER && MidnightControlsConfig.virtualMouse) {
            ci.setReturnValue((Object)true);
            ci.cancel();
        }
    }

    @Inject(method={"grabMouse()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void midnightcontrols$onCursorLocked(CallbackInfo ci) {
        if (MidnightControlsConfig.controlsMode == ControlsMode.CONTROLLER && MidnightControlsConfig.virtualMouse || MidnightControlsConfig.controlsMode == ControlsMode.TOUCHSCREEN || MidnightControlsConfig.doMixedInput()) {
            ci.cancel();
        }
    }

    @Inject(method={"turnPlayer(D)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void midnightcontrols$updateMouse(CallbackInfo ci) {
        if (MidnightControlsConfig.eyeTrackerAsMouse && this.mouseGrabbed && this.minecraft.isWindowActive()) {
            if (!this.minecraft.options.smoothCamera) {
                this.smoothTurnX.reset();
                this.smoothTurnY.reset();
            }
            EyeTrackerHandler.updateMouseWithEyeTracking(this.xpos + this.accumulatedDX, this.ypos + this.accumulatedDY, this.minecraft, this.mousePressedTime, this.isLeftPressed, this.midnightcontrols$isUsingLongRangedTool(), this.smoothTurnX, this.smoothTurnY);
            this.mousePressedTime = Blaze3D.getTime();
            this.accumulatedDX = 0.0;
            this.accumulatedDY = 0.0;
            ci.cancel();
        }
        if (MidnightControlsConfig.doMixedInput() && this.minecraft.isWindowActive()) {
            ci.cancel();
        }
    }

    @Unique
    private boolean midnightcontrols$isUsingLongRangedTool() {
        if (this.minecraft.player == null) {
            return false;
        }
        ItemStack stack = this.minecraft.player.getUseItem();
        return this.isLeftPressed && (stack.getUseAnimation() == UseAnim.BOW || stack.getUseAnimation() == UseAnim.CROSSBOW || stack.getUseAnimation() == UseAnim.SPEAR || stack.getItem() instanceof ThrowablePotionItem);
    }

    @Inject(method={"grabMouse()V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/platform/InputConstants;grabOrReleaseMouse(JIDD)V", shift=At.Shift.BEFORE)}, cancellable=true)
    private void midnightcontrols$lockCursor(CallbackInfo ci) {
        if (MidnightControlsConfig.doMixedInput() || MidnightControlsConfig.eyeTrackerAsMouse) {
            GLFW.glfwSetInputMode((long)this.minecraft.getWindow().getWindow(), (int)208897, (int)212994);
            this.minecraft.setScreen(null);
            this.ignoreFirstMove = true;
            ci.cancel();
        }
    }
}

