/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client.mouse;

import com.mojang.blaze3d.Blaze3D;
import eu.midnightdust.midnightcontrols.client.MidnightControlsConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.util.SmoothDouble;

public class EyeTrackerHandler {
    public static void updateMouseWithEyeTracking(double mouseX, double mouseY, Minecraft client, double lastMouseUpdateTime, boolean holdingLeftMouseButton, boolean usingLongRangedTool, SmoothDouble smoothX, SmoothDouble smoothY) {
        boolean notInDeadzone;
        if (client.player == null) {
            return;
        }
        double deltaTime = Blaze3D.getTime() - lastMouseUpdateTime;
        double centerX = (double)client.getWindow().getScreenWidth() / 2.0;
        double centerY = (double)client.getWindow().getScreenHeight() / 2.0;
        double gazeRawX = mouseX - centerX;
        double gazeRawY = mouseY - centerY;
        double feeling = 2.5;
        double sensitivity = (Double)client.options.sensitivity().get() * feeling;
        double spyglass = sensitivity * sensitivity * sensitivity;
        double moveScalar = spyglass * 8.0;
        double frameScalar = client.options.getCameraType().isFirstPerson() && client.player.isScoping() ? spyglass : moveScalar;
        if (holdingLeftMouseButton && !usingLongRangedTool) {
            frameScalar *= 0.5;
        }
        double magnitudeMax = Math.sqrt(centerX * centerX + centerY * centerY);
        double normalizedX = gazeRawX / magnitudeMax;
        double normalizedY = gazeRawY / magnitudeMax;
        double moveX = normalizedX * frameScalar;
        double moveY = normalizedY * frameScalar;
        if (client.options.smoothCamera) {
            moveX = smoothX.getNewDeltaValue(moveX, moveScalar * deltaTime);
            moveY = smoothY.getNewDeltaValue(moveY, moveScalar * deltaTime);
        }
        double invertY = 1.0;
        double moveMagnitude = Math.sqrt(normalizedX * normalizedX + normalizedY * normalizedY);
        if (((Boolean)client.options.invertYMouse().get()).booleanValue()) {
            invertY = -1.0;
        }
        boolean bl = notInDeadzone = moveMagnitude > MidnightControlsConfig.eyeTrackerDeadzone && !usingLongRangedTool;
        if (client.player != null && notInDeadzone) {
            client.player.turn(moveX, moveY * invertY);
            client.getTutorial().onMouse(moveX, moveY);
        }
    }
}

