/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client.ring;

import com.google.gson.Gson;
import eu.midnightdust.midnightcontrols.client.controller.ButtonBinding;
import eu.midnightdust.midnightcontrols.client.enums.ButtonState;
import eu.midnightdust.midnightcontrols.client.ring.RingAction;
import eu.midnightdust.midnightcontrols.client.ring.RingButtonMode;
import eu.midnightdust.midnightcontrols.client.util.KeyBindingAccessor;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ButtonBindingRingAction
extends RingAction {
    public static final Factory FACTORY = new Factory();
    public final ButtonBinding binding;

    public ButtonBindingRingAction(@NotNull ButtonBinding binding) {
        this.binding = binding;
    }

    @NotNull
    public String getName() {
        return this.binding.getTranslationKey();
    }

    @Override
    public void onAction(@NotNull RingButtonMode mode) {
        this.binding.handle(Minecraft.getInstance(), 1.0f, ButtonState.PRESS);
        if (this.binding.asKeyBinding().isPresent()) {
            this.binding.asKeyBinding().get().setDown(true);
            ((KeyBindingAccessor)this.binding.asKeyBinding().get()).midnightcontrols$press();
        }
    }

    @Override
    public void drawIcon(@NotNull GuiGraphics context, @NotNull Font textRenderer, int x, int y, boolean hovered) {
        List lines = textRenderer.split((FormattedText)Component.translatable((String)this.getName()), 75);
        for (int i = 0; i < lines.size(); ++i) {
            FormattedCharSequence formattedCharSequence = (FormattedCharSequence)lines.get(i);
            Objects.requireNonNull(textRenderer);
            int n = y + 37 - 9 / 2 * (lines.size() - 1);
            Objects.requireNonNull(textRenderer);
            int n2 = n - 9 / 2;
            Objects.requireNonNull(textRenderer);
            context.drawCenteredString(textRenderer, formattedCharSequence, x + 37, n2 + 9 * i, 0xFFFFFF);
        }
    }

    protected static class Factory
    implements RingAction.Factory {
        protected Factory() {
        }

        @Override
        @NotNull
        public Supplier<RingAction> newFromGui(@NotNull Screen screen) {
            return () -> null;
        }

        @Override
        @Nullable
        public RingAction parse(@NotNull Gson config) {
            return null;
        }
    }
}

