/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client.touch;

import eu.midnightdust.lib.util.PlatformFunctions;
import eu.midnightdust.midnightcontrols.client.MidnightControlsConfig;
import eu.midnightdust.midnightcontrols.client.MidnightReacharound;
import eu.midnightdust.midnightcontrols.client.enums.TouchMode;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL11;

public class TouchUtils {
    private static final Minecraft client = Minecraft.getInstance();
    public static final Matrix4f lastWorldSpaceMatrix = new Matrix4f();
    public static final Matrix4f lastProjMat = new Matrix4f();
    public static final Matrix4f lastModMat = new Matrix4f();

    public static HitResult getTargetedObject(double mouseX, double mouseY) {
        if (TouchUtils.client.player == null || TouchUtils.client.level == null || MidnightControlsConfig.touchMode == TouchMode.CROSSHAIR || PlatformFunctions.isModLoaded((String)"vulkanmod")) {
            return TouchUtils.client.hitResult;
        }
        Vec3 near = TouchUtils.screenSpaceToWorldSpace(mouseX, mouseY, 0.0);
        Vec3 far = TouchUtils.screenSpaceToWorldSpace(mouseX, mouseY, 1.0);
        float playerRange = MidnightReacharound.getPlayerRange(client);
        EntityHitResult entityCast = ProjectileUtil.getEntityHitResult((Entity)TouchUtils.client.player, (Vec3)near, (Vec3)far, (AABB)AABB.unitCubeFromLowerCorner((Vec3)TouchUtils.client.player.position()).inflate((double)playerRange), entity -> !entity.isSpectator() && entity.isAttackable(), (double)(playerRange * playerRange));
        if (entityCast != null && entityCast.getType() == HitResult.Type.ENTITY) {
            return entityCast;
        }
        BlockHitResult result = TouchUtils.client.level.clip(new ClipContext(near, far, ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY, (Entity)TouchUtils.client.player));
        if (TouchUtils.client.player.position().distanceTo(result.getLocation()) > (double)playerRange) {
            return null;
        }
        return result;
    }

    public static Vec3 screenSpaceToWorldSpace(double x, double y, double d) {
        Camera camera = TouchUtils.client.getEntityRenderDispatcher().camera;
        int displayHeight = client.getWindow().getGuiScaledHeight();
        int displayWidth = client.getWindow().getGuiScaledWidth();
        int[] viewport = new int[4];
        GL11.glGetIntegerv((int)2978, (int[])viewport);
        Vector3f target = new Vector3f();
        Matrix4f matrixProj = new Matrix4f((Matrix4fc)lastProjMat);
        Matrix4f matrixModel = new Matrix4f((Matrix4fc)lastModMat);
        matrixProj.mul((Matrix4fc)matrixModel).mul((Matrix4fc)lastWorldSpaceMatrix).unproject((float)x / (float)displayWidth * (float)viewport[2], (float)((double)displayHeight - y) / (float)displayHeight * (float)viewport[3], (float)d, viewport, target);
        return new Vec3((double)target.x, (double)target.y, (double)target.z).add(camera.getPosition());
    }

    public static boolean hasInWorldUseAction(ItemStack stack) {
        UseAnim action = stack.getUseAnimation();
        return action == UseAnim.BOW || action == UseAnim.BRUSH || action == UseAnim.SPEAR;
    }
}

