/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client.util;

import eu.midnightdust.midnightcontrols.client.MidnightControlsClient;
import eu.midnightdust.midnightcontrols.client.util.HandledScreenAccessor;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.util.Tuple;
import net.minecraft.world.inventory.Slot;
import org.aperlambda.lambdacommon.utils.Pair;
import org.jetbrains.annotations.Nullable;

public class InventoryUtil {
    private static int targetMouseX = 0;
    private static int targetMouseY = 0;

    public static Optional<Slot> findClosestSlot(AbstractContainerScreen<?> inventory, int direction) {
        HandledScreenAccessor accessor = (HandledScreenAccessor)inventory;
        int guiLeft = accessor.getX();
        int guiTop = accessor.getY();
        double mouseX = MidnightControlsClient.client.mouseHandler.xpos() * (double)MidnightControlsClient.client.getWindow().getGuiScaledWidth() / (double)MidnightControlsClient.client.getWindow().getScreenWidth();
        double mouseY = MidnightControlsClient.client.mouseHandler.ypos() * (double)MidnightControlsClient.client.getWindow().getGuiScaledHeight() / (double)MidnightControlsClient.client.getWindow().getScreenHeight();
        Slot mouseSlot = accessor.midnightcontrols$getSlotAt(mouseX, mouseY);
        return inventory.getMenu().slots.parallelStream().filter(Predicate.isEqual(mouseSlot).negate()).map(slot -> {
            int posX = guiLeft + slot.x + 8;
            int posY = guiTop + slot.y + 8;
            int otherPosX = (int)mouseX;
            int otherPosY = (int)mouseY;
            if (mouseSlot != null) {
                otherPosX = guiLeft + mouseSlot.x + 8;
                otherPosY = guiTop + mouseSlot.y + 8;
            }
            double distance = Math.sqrt(Math.pow(posX - otherPosX, 2.0) + Math.pow(posY - otherPosY, 2.0));
            return Pair.of(slot, distance);
        }).filter(entry -> {
            Slot slot = (Slot)entry.key;
            int posX = guiLeft + slot.x + 8;
            int posY = guiTop + slot.y + 8;
            int otherPosX = (int)mouseX;
            int otherPosY = (int)mouseY;
            if (mouseSlot != null) {
                otherPosX = guiLeft + mouseSlot.x + 8;
                otherPosY = guiTop + mouseSlot.y + 8;
            }
            if (direction == 0) {
                return posY < otherPosY;
            }
            if (direction == 1) {
                return posY > otherPosY;
            }
            if (direction == 2) {
                return posX > otherPosX;
            }
            if (direction == 3) {
                return posX < otherPosX;
            }
            return false;
        }).min(Comparator.comparingDouble(p -> (Double)p.value)).map(p -> (Slot)p.key);
    }

    public static void moveMouseToClosestSlot(@Nullable Screen screen) {
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen inventoryScreen = (AbstractContainerScreen)screen;
            HandledScreenAccessor accessor = (HandledScreenAccessor)inventoryScreen;
            int guiLeft = accessor.getX();
            int guiTop = accessor.getY();
            int mouseX = (int)((double)targetMouseX * (double)MidnightControlsClient.client.getWindow().getGuiScaledWidth() / (double)MidnightControlsClient.client.getWindow().getScreenWidth());
            int mouseY = (int)((double)targetMouseY * (double)MidnightControlsClient.client.getWindow().getGuiScaledHeight() / (double)MidnightControlsClient.client.getWindow().getScreenHeight());
            Optional<Tuple> closestSlot = inventoryScreen.getMenu().slots.parallelStream().map(slot -> {
                int x = guiLeft + slot.x + 8;
                int y = guiTop + slot.y + 8;
                double distance = Math.sqrt(Math.pow(x - mouseX, 2.0) + Math.pow(y - mouseY, 2.0));
                return new Tuple(slot, (Object)distance);
            }).filter(entry -> (Double)entry.getB() <= 14.0).min(Comparator.comparingDouble(Tuple::getB));
            if (closestSlot.isPresent() && MidnightControlsClient.client.player != null) {
                Slot slot2 = (Slot)closestSlot.get().getA();
                if (slot2.hasItem() || !MidnightControlsClient.client.player.getInventory().getSelected().isEmpty()) {
                    int slotCenterXScaled = guiLeft + slot2.x + 8;
                    int slotCenterYScaled = guiTop + slot2.y + 8;
                    int slotCenterX = (int)((double)slotCenterXScaled / ((double)MidnightControlsClient.client.getWindow().getGuiScaledWidth() / (double)MidnightControlsClient.client.getWindow().getScreenWidth()));
                    int slotCenterY = (int)((double)slotCenterYScaled / ((double)MidnightControlsClient.client.getWindow().getGuiScaledHeight() / (double)MidnightControlsClient.client.getWindow().getScreenHeight()));
                    double deltaX = slotCenterX - targetMouseX;
                    double deltaY = slotCenterY - targetMouseY;
                    if (mouseX != slotCenterXScaled || mouseY != slotCenterYScaled) {
                        targetMouseX += (int)(deltaX * 0.75);
                        targetMouseY += (int)(deltaY * 0.75);
                    } else {
                        MidnightControlsClient.input.mouseSpeedX *= 0.3f;
                        MidnightControlsClient.input.mouseSpeedY *= 0.3f;
                    }
                    MidnightControlsClient.input.mouseSpeedX *= 0.75f;
                    MidnightControlsClient.input.mouseSpeedY *= 0.75f;
                } else {
                    MidnightControlsClient.input.mouseSpeedX *= 0.1f;
                    MidnightControlsClient.input.mouseSpeedY *= 0.1f;
                }
            } else {
                MidnightControlsClient.input.mouseSpeedX *= 0.3f;
                MidnightControlsClient.input.mouseSpeedY *= 0.3f;
            }
        } else {
            MidnightControlsClient.input.mouseSpeedX = 0.0f;
            MidnightControlsClient.input.mouseSpeedY = 0.0f;
        }
    }
}

