/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client.util.storage;

import eu.midnightdust.midnightcontrols.client.MidnightControlsConfig;
import eu.midnightdust.midnightcontrols.client.MidnightInput;
import eu.midnightdust.midnightcontrols.client.controller.ButtonBinding;
import eu.midnightdust.midnightcontrols.client.controller.InputManager;
import eu.midnightdust.midnightcontrols.client.enums.ButtonState;

public class AxisStorage {
    public final int axis;
    public float value;
    public float absValue;
    public final double deadZone;
    public final Polarity polarity;
    public final boolean isTrigger;
    public final ButtonState buttonState;

    public static AxisStorage of(int axis, float value) {
        return new AxisStorage(axis, value, AxisStorage.isLeftAxis(axis) ? MidnightControlsConfig.leftDeadZone : MidnightControlsConfig.rightDeadZone);
    }

    public static AxisStorage of(int axis, float value, double deadZone) {
        return new AxisStorage(axis, value, deadZone);
    }

    private AxisStorage(int axis, float value, double deadZone) {
        boolean currentMinusState;
        this.axis = axis;
        this.deadZone = deadZone;
        if (axis == 4 || axis == 5 || axis == ButtonBinding.controller2Button(4) || axis == ButtonBinding.controller2Button(5)) {
            this.isTrigger = true;
            if (value < -0.5f) {
                value = 0.0f;
            } else if (MidnightControlsConfig.triggerFix) {
                value = 1.0f;
            }
        } else {
            this.isTrigger = false;
        }
        this.value = value;
        this.buttonState = value > 0.5f ? ButtonState.PRESS : (value < -0.5f ? ButtonState.RELEASE : ButtonState.NONE);
        this.absValue = Math.abs(value);
        boolean currentPlusState = (double)value > deadZone;
        boolean bl = currentMinusState = (double)value < -deadZone;
        if (this.isTrigger) {
            currentMinusState = false;
        } else if (!MidnightControlsConfig.analogMovement && AxisStorage.isLeftAxis(axis)) {
            currentPlusState = this.buttonState == ButtonState.PRESS;
            boolean bl2 = currentMinusState = this.buttonState == ButtonState.RELEASE;
        }
        this.polarity = currentPlusState ? Polarity.PLUS : (currentMinusState ? Polarity.MINUS : Polarity.ZERO);
    }

    public int getButtonId(boolean positive) {
        return ButtonBinding.axisAsButton(this.axis, positive);
    }

    public void setupButtonStates() {
        int posButton = this.getButtonId(true);
        int negButton = this.getButtonId(false);
        ButtonState previousPlusState = (ButtonState)((Object)InputManager.STATES.getOrDefault(posButton, (Object)ButtonState.NONE));
        ButtonState previousMinusState = (ButtonState)((Object)InputManager.STATES.getOrDefault(negButton, (Object)ButtonState.NONE));
        if (this.polarity.isPositive() != previousPlusState.isPressed()) {
            InputManager.STATES.put(posButton, (Object)(this.polarity.isPositive() ? ButtonState.PRESS : ButtonState.RELEASE));
            if (this.polarity.isPositive()) {
                MidnightInput.BUTTON_COOLDOWNS.put(posButton, 5);
            }
        } else if (this.polarity.isPositive()) {
            InputManager.STATES.put(posButton, (Object)ButtonState.REPEAT);
            if (MidnightInput.BUTTON_COOLDOWNS.getOrDefault(posButton, 0) == 0) {
                MidnightInput.BUTTON_COOLDOWNS.put(posButton, 5);
            }
        }
        if (this.polarity.isNegative() != previousMinusState.isPressed()) {
            InputManager.STATES.put(negButton, (Object)(this.polarity.isNegative() ? ButtonState.PRESS : ButtonState.RELEASE));
            if (this.polarity.isNegative()) {
                MidnightInput.BUTTON_COOLDOWNS.put(negButton, 5);
            }
        } else if (this.polarity.isNegative()) {
            InputManager.STATES.put(negButton, (Object)ButtonState.REPEAT);
            if (MidnightInput.BUTTON_COOLDOWNS.getOrDefault(negButton, 0) == 0) {
                MidnightInput.BUTTON_COOLDOWNS.put(negButton, 5);
            }
        }
    }

    public static boolean isLeftAxis(int axis) {
        return axis == 0 || axis == 1 || axis == 4;
    }

    public static boolean isRightAxis(int axis) {
        return !AxisStorage.isLeftAxis(axis);
    }

    public static enum Polarity {
        MINUS(-1),
        ZERO(0),
        PLUS(1);

        public final int multiplier;

        private Polarity(int multiplier) {
            this.multiplier = multiplier;
        }

        public boolean isPositive() {
            return this == PLUS;
        }

        public boolean isNegative() {
            return this == MINUS;
        }
    }
}

